@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Identity Provider Type identifier.
 */
public enum class IdentityProviderType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.IdentityProviderType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.IdentityProviderType> {
    /**
     * Facebook as Identity provider.
     */
    Facebook(com.pulumi.azurenative.apimanagement.enums.IdentityProviderType.Facebook),

    /**
     * Google as Identity provider.
     */
    Google(com.pulumi.azurenative.apimanagement.enums.IdentityProviderType.Google),

    /**
     * Microsoft Live as Identity provider.
     */
    Microsoft(com.pulumi.azurenative.apimanagement.enums.IdentityProviderType.Microsoft),

    /**
     * Twitter as Identity provider.
     */
    Twitter(com.pulumi.azurenative.apimanagement.enums.IdentityProviderType.Twitter),

    /**
     * Azure Active Directory as Identity provider.
     */
    Aad(com.pulumi.azurenative.apimanagement.enums.IdentityProviderType.Aad),

    /**
     * Azure Active Directory B2C as Identity provider.
     */
    AadB2C(com.pulumi.azurenative.apimanagement.enums.IdentityProviderType.AadB2C),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.IdentityProviderType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.IdentityProviderType):
            IdentityProviderType = IdentityProviderType.values().first { it.javaValue == javaType }
    }
}
