@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * OAuth2 grant type options
 */
public enum class OAuth2GrantType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.OAuth2GrantType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.OAuth2GrantType> {
    /**
     * Authorization Code grant
     */
    AuthorizationCode(com.pulumi.azurenative.apimanagement.enums.OAuth2GrantType.AuthorizationCode),

    /**
     * Client Credential grant
     */
    ClientCredentials(com.pulumi.azurenative.apimanagement.enums.OAuth2GrantType.ClientCredentials),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.OAuth2GrantType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.OAuth2GrantType):
            OAuth2GrantType = OAuth2GrantType.values().first { it.javaValue == javaType }
    }
}
