@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates if base policy should be enforced for the policy document.
 */
public enum class PolicyRestrictionRequireBase(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.PolicyRestrictionRequireBase,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.PolicyRestrictionRequireBase> {
    /**
     * The policy is required to have base policy
     */
    True_(com.pulumi.azurenative.apimanagement.enums.PolicyRestrictionRequireBase.True_),

    /**
     * The policy does not require to have base policy
     */
    False_(com.pulumi.azurenative.apimanagement.enums.PolicyRestrictionRequireBase.False_),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.PolicyRestrictionRequireBase =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.PolicyRestrictionRequireBase):
            PolicyRestrictionRequireBase =
            PolicyRestrictionRequireBase.values().first { it.javaValue == javaType }
    }
}
