@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Schema Type. Immutable.
 */
public enum class SchemaType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.SchemaType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.SchemaType> {
    /**
     * XML schema type.
     */
    Xml(com.pulumi.azurenative.apimanagement.enums.SchemaType.Xml),

    /**
     * Json schema type.
     */
    Json(com.pulumi.azurenative.apimanagement.enums.SchemaType.Json),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.SchemaType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.SchemaType): SchemaType =
            SchemaType.values().first { it.javaValue == javaType }
    }
}
