@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active.
 */
public enum class UserState(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.UserState,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.UserState> {
    /**
     * User state is active.
     */
    Active(com.pulumi.azurenative.apimanagement.enums.UserState.Active),

    /**
     * User is blocked. Blocked users cannot authenticate at developer portal or call API.
     */
    Blocked(com.pulumi.azurenative.apimanagement.enums.UserState.Blocked),

    /**
     * User account is pending. Requires identity confirmation before it can be made active.
     */
    Pending(com.pulumi.azurenative.apimanagement.enums.UserState.Pending),

    /**
     * User account is closed. All identities and related entities are removed.
     */
    Deleted(com.pulumi.azurenative.apimanagement.enums.UserState.Deleted),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.UserState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.UserState): UserState =
            UserState.values().first { it.javaValue == javaType }
    }
}
