@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiLicenseInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API license information
 * @property name The license name used for the API
 * @property url A URL to the license used for the API. MUST be in the format of a URL
 */
public data class ApiLicenseInformationArgs(
    public val name: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiLicenseInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.ApiLicenseInformationArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiLicenseInformationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiLicenseInformationArgs].
 */
@PulumiTagMarker
public class ApiLicenseInformationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The license name used for the API
     */
    @JvmName("wcbpviojakkkjijw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A URL to the license used for the API. MUST be in the format of a URL
     */
    @JvmName("gdqskanecthqiqjg")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The license name used for the API
     */
    @JvmName("gomnrbrlajslnkrp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A URL to the license used for the API. MUST be in the format of a URL
     */
    @JvmName("wmuwijblqvmrwnci")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ApiLicenseInformationArgs = ApiLicenseInformationArgs(
        name = name,
        url = url,
    )
}
