@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BackendAuthorizationHeaderCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorization header information.
 * @property parameter Authentication Parameter value.
 * @property scheme Authentication Scheme name.
 */
public data class BackendAuthorizationHeaderCredentialsArgs(
    public val parameter: Output<String>,
    public val scheme: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BackendAuthorizationHeaderCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.BackendAuthorizationHeaderCredentialsArgs =
        com.pulumi.azurenative.apimanagement.inputs.BackendAuthorizationHeaderCredentialsArgs.builder()
            .parameter(parameter.applyValue({ args0 -> args0 }))
            .scheme(scheme.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendAuthorizationHeaderCredentialsArgs].
 */
@PulumiTagMarker
public class BackendAuthorizationHeaderCredentialsArgsBuilder internal constructor() {
    private var parameter: Output<String>? = null

    private var scheme: Output<String>? = null

    /**
     * @param value Authentication Parameter value.
     */
    @JvmName("bnbskcbjsphwieuu")
    public suspend fun parameter(`value`: Output<String>) {
        this.parameter = value
    }

    /**
     * @param value Authentication Scheme name.
     */
    @JvmName("frvtbsivapmmdkrq")
    public suspend fun scheme(`value`: Output<String>) {
        this.scheme = value
    }

    /**
     * @param value Authentication Parameter value.
     */
    @JvmName("kixxmkyecjkubdpo")
    public suspend fun parameter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameter = mapped
    }

    /**
     * @param value Authentication Scheme name.
     */
    @JvmName("gwixrxfltjknsglh")
    public suspend fun scheme(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): BackendAuthorizationHeaderCredentialsArgs =
        BackendAuthorizationHeaderCredentialsArgs(
            parameter = parameter ?: throw PulumiNullFieldException("parameter"),
            scheme = scheme ?: throw PulumiNullFieldException("scheme"),
        )
}
