@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiDiagnosticPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property diagnosticId Diagnostic identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetApiDiagnosticPlainArgs(
    public val apiId: String,
    public val diagnosticId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiDiagnosticPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiDiagnosticPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiDiagnosticPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .diagnosticId(diagnosticId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiDiagnosticPlainArgs].
 */
@PulumiTagMarker
public class GetApiDiagnosticPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var diagnosticId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ianlgtthwljjujjs")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Diagnostic identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("dvnoumnuprvnqnyg")
    public suspend fun diagnosticId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diagnosticId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yogvpqvmjutcphga")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("tkfihctkidsqeipl")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiDiagnosticPlainArgs = GetApiDiagnosticPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        diagnosticId = diagnosticId ?: throw PulumiNullFieldException("diagnosticId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
