@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiIssueCommentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property commentId Comment identifier within an Issue. Must be unique in the current Issue.
 * @property issueId Issue identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetApiIssueCommentPlainArgs(
    public val apiId: String,
    public val commentId: String,
    public val issueId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiIssueCommentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiIssueCommentPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiIssueCommentPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .commentId(commentId.let({ args0 -> args0 }))
            .issueId(issueId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiIssueCommentPlainArgs].
 */
@PulumiTagMarker
public class GetApiIssueCommentPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var commentId: String? = null

    private var issueId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ifvqosopyurkratd")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Comment identifier within an Issue. Must be unique in the current Issue.
     */
    @JvmName("teatkippxbickilh")
    public suspend fun commentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commentId = mapped
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("uspsjgdnhodjkcxu")
    public suspend fun issueId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.issueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nfovesavramuigbi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("eggqcbuurqnwljkl")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiIssueCommentPlainArgs = GetApiIssueCommentPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        commentId = commentId ?: throw PulumiNullFieldException("commentId"),
        issueId = issueId ?: throw PulumiNullFieldException("issueId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
