@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiIssuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property expandCommentsAttachments Expand the comment attachments.
 * @property issueId Issue identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetApiIssuePlainArgs(
    public val apiId: String,
    public val expandCommentsAttachments: Boolean? = null,
    public val issueId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiIssuePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiIssuePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiIssuePlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .expandCommentsAttachments(expandCommentsAttachments?.let({ args0 -> args0 }))
            .issueId(issueId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiIssuePlainArgs].
 */
@PulumiTagMarker
public class GetApiIssuePlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var expandCommentsAttachments: Boolean? = null

    private var issueId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("gbfridtuyfpejgth")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Expand the comment attachments.
     */
    @JvmName("wvarkohibtsefvfj")
    public suspend fun expandCommentsAttachments(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expandCommentsAttachments = mapped
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("dtxfgcxswbpyunmc")
    public suspend fun issueId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.issueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xivmxkthulliaiho")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vincouchcmfwucjr")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiIssuePlainArgs = GetApiIssuePlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        expandCommentsAttachments = expandCommentsAttachments,
        issueId = issueId ?: throw PulumiNullFieldException("issueId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
