@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiTagDescriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagDescriptionId Tag description identifier. Used when creating tagDescription for API/Tag association. Based on API and Tag names.
 */
public data class GetApiTagDescriptionPlainArgs(
    public val apiId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val tagDescriptionId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiTagDescriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiTagDescriptionPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiTagDescriptionPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .tagDescriptionId(tagDescriptionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiTagDescriptionPlainArgs].
 */
@PulumiTagMarker
public class GetApiTagDescriptionPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var tagDescriptionId: String? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("rbumxhvsslwdrtqe")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kttqauqhdiogswto")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("okagkxnocppdodsh")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Tag description identifier. Used when creating tagDescription for API/Tag association. Based on API and Tag names.
     */
    @JvmName("kvhwqyipjmewuepn")
    public suspend fun tagDescriptionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagDescriptionId = mapped
    }

    internal fun build(): GetApiTagDescriptionPlainArgs = GetApiTagDescriptionPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        tagDescriptionId = tagDescriptionId ?: throw PulumiNullFieldException("tagDescriptionId"),
    )
}
