@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationLoginLinkPostPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationId Identifier of the authorization.
 * @property authorizationProviderId Identifier of the authorization provider.
 * @property postLoginRedirectUrl The redirect URL after login has completed.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetAuthorizationLoginLinkPostPlainArgs(
    public val authorizationId: String,
    public val authorizationProviderId: String,
    public val postLoginRedirectUrl: String? = null,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationLoginLinkPostPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationLoginLinkPostPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationLoginLinkPostPlainArgs.builder()
            .authorizationId(authorizationId.let({ args0 -> args0 }))
            .authorizationProviderId(authorizationProviderId.let({ args0 -> args0 }))
            .postLoginRedirectUrl(postLoginRedirectUrl?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizationLoginLinkPostPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizationLoginLinkPostPlainArgsBuilder internal constructor() {
    private var authorizationId: String? = null

    private var authorizationProviderId: String? = null

    private var postLoginRedirectUrl: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identifier of the authorization.
     */
    @JvmName("lwnipoiljdaqitqe")
    public suspend fun authorizationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationId = mapped
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("ayljpfnxsyycyqty")
    public suspend fun authorizationProviderId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationProviderId = mapped
    }

    /**
     * @param value The redirect URL after login has completed.
     */
    @JvmName("mkmenlrdppdymokc")
    public suspend fun postLoginRedirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.postLoginRedirectUrl = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("osovjjrvtddjiwtc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("nsuviuoumuhgsxiq")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetAuthorizationLoginLinkPostPlainArgs =
        GetAuthorizationLoginLinkPostPlainArgs(
            authorizationId = authorizationId ?: throw PulumiNullFieldException("authorizationId"),
            authorizationProviderId = authorizationProviderId ?: throw
                PulumiNullFieldException("authorizationProviderId"),
            postLoginRedirectUrl = postLoginRedirectUrl,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
