@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetContentItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentItemId Content item identifier.
 * @property contentTypeId Content type identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetContentItemPlainArgs(
    public val contentItemId: String,
    public val contentTypeId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetContentItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetContentItemPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetContentItemPlainArgs.builder()
            .contentItemId(contentItemId.let({ args0 -> args0 }))
            .contentTypeId(contentTypeId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContentItemPlainArgs].
 */
@PulumiTagMarker
public class GetContentItemPlainArgsBuilder internal constructor() {
    private var contentItemId: String? = null

    private var contentTypeId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Content item identifier.
     */
    @JvmName("xpvnlfsdovadwyit")
    public suspend fun contentItemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contentItemId = mapped
    }

    /**
     * @param value Content type identifier.
     */
    @JvmName("opnmdeqivrbvcwgx")
    public suspend fun contentTypeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contentTypeId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("duoyjtgmmxljxgeu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("sinluwbhjcwnkwej")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetContentItemPlainArgs = GetContentItemPlainArgs(
        contentItemId = contentItemId ?: throw PulumiNullFieldException("contentItemId"),
        contentTypeId = contentTypeId ?: throw PulumiNullFieldException("contentTypeId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
