@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetGraphQLApiResolverPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property format Policy Export Format.
 * @property policyId The identifier of the Policy.
 * @property resolverId Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetGraphQLApiResolverPolicyPlainArgs(
    public val apiId: String,
    public val format: String? = null,
    public val policyId: String,
    public val resolverId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetGraphQLApiResolverPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetGraphQLApiResolverPolicyPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetGraphQLApiResolverPolicyPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .format(format?.let({ args0 -> args0 }))
            .policyId(policyId.let({ args0 -> args0 }))
            .resolverId(resolverId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGraphQLApiResolverPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetGraphQLApiResolverPolicyPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var format: String? = null

    private var policyId: String? = null

    private var resolverId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("cmpsbllillsqpvie")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Policy Export Format.
     */
    @JvmName("ghelhocxnbdhpwik")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("nphkeaiyhypbcfyg")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyId = mapped
    }

    /**
     * @param value Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     */
    @JvmName("sfymivksotowjukk")
    public suspend fun resolverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resolverId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fgacxuxelqowwtvf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("oamyhioposvwvhtr")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetGraphQLApiResolverPolicyPlainArgs = GetGraphQLApiResolverPolicyPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        format = format,
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
        resolverId = resolverId ?: throw PulumiNullFieldException("resolverId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
