@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetIdentityProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property identityProviderName Identity Provider Type identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetIdentityProviderPlainArgs(
    public val identityProviderName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetIdentityProviderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetIdentityProviderPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetIdentityProviderPlainArgs.builder()
            .identityProviderName(identityProviderName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIdentityProviderPlainArgs].
 */
@PulumiTagMarker
public class GetIdentityProviderPlainArgsBuilder internal constructor() {
    private var identityProviderName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("wwybxdttbdstwsja")
    public suspend fun identityProviderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identityProviderName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wewgdnttfckxumug")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("fvcxsmmxslviidnc")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetIdentityProviderPlainArgs = GetIdentityProviderPlainArgs(
        identityProviderName = identityProviderName ?: throw
            PulumiNullFieldException("identityProviderName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
