@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetPrivateEndpointConnectionByNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName Name of the private endpoint connection.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetPrivateEndpointConnectionByNamePlainArgs(
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetPrivateEndpointConnectionByNamePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetPrivateEndpointConnectionByNamePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetPrivateEndpointConnectionByNamePlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionByNamePlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionByNamePlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Name of the private endpoint connection.
     */
    @JvmName("mexpfmlieioktehu")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kfwgjmaluaneclgo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("hcgmmqllpwnrwygm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionByNamePlainArgs =
        GetPrivateEndpointConnectionByNamePlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
