@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetProductApiLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiLinkId Product-API link identifier. Must be unique in the current API Management service instance.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetProductApiLinkPlainArgs(
    public val apiLinkId: String,
    public val productId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetProductApiLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetProductApiLinkPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetProductApiLinkPlainArgs.builder()
            .apiLinkId(apiLinkId.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductApiLinkPlainArgs].
 */
@PulumiTagMarker
public class GetProductApiLinkPlainArgsBuilder internal constructor() {
    private var apiLinkId: String? = null

    private var productId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Product-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("rcdgjsfeavoaaflw")
    public suspend fun apiLinkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiLinkId = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ijjofqbdbyywgjfv")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cfyabxwcvmisdifq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("biokeedybnnspfip")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetProductApiLinkPlainArgs = GetProductApiLinkPlainArgs(
        apiLinkId = apiLinkId ?: throw PulumiNullFieldException("apiLinkId"),
        productId = productId ?: throw PulumiNullFieldException("productId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
