@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetTagPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 */
public data class GetTagPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val tagId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetTagPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetTagPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetTagPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .tagId(tagId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagPlainArgs].
 */
@PulumiTagMarker
public class GetTagPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var tagId: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjsovldcuklvdbpu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xpyybqytemnsscht")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("bjxpqqofvoukwxyf")
    public suspend fun tagId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagId = mapped
    }

    internal fun build(): GetTagPlainArgs = GetTagPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        tagId = tagId ?: throw PulumiNullFieldException("tagId"),
    )
}
