@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiVersionSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property versionSetId Api Version Set identifier. Must be unique in the current API Management service instance.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspaceApiVersionSetPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val versionSetId: String,
    public val workspaceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiVersionSetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiVersionSetPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiVersionSetPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .versionSetId(versionSetId.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceApiVersionSetPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceApiVersionSetPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var versionSetId: String? = null

    private var workspaceId: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jkcoxorcnrfqseyp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("gqoxwjlaguglwhct")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Api Version Set identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("mpdvkohaxpmiqcpg")
    public suspend fun versionSetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionSetId = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("vvlteqhnvhngvsgc")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspaceApiVersionSetPlainArgs = GetWorkspaceApiVersionSetPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        versionSetId = versionSetId ?: throw PulumiNullFieldException("versionSetId"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
