@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductApiLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiLinkId Product-API link identifier. Must be unique in the current API Management service instance.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspaceProductApiLinkPlainArgs(
    public val apiLinkId: String,
    public val productId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductApiLinkPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductApiLinkPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductApiLinkPlainArgs.builder()
            .apiLinkId(apiLinkId.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceProductApiLinkPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceProductApiLinkPlainArgsBuilder internal constructor() {
    private var apiLinkId: String? = null

    private var productId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value Product-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("sxwcwbpuqwxeckiu")
    public suspend fun apiLinkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiLinkId = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hgfktfxkdtnnemse")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sihxafwnmxtpcfui")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("hlngkyakgaqedmoc")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("aqbwgbghvelqpgem")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspaceProductApiLinkPlainArgs = GetWorkspaceProductApiLinkPlainArgs(
        apiLinkId = apiLinkId ?: throw PulumiNullFieldException("apiLinkId"),
        productId = productId ?: throw PulumiNullFieldException("productId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
