@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format Policy Export Format.
 * @property policyId The identifier of the Policy.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspaceProductPolicyPlainArgs(
    public val format: String? = null,
    public val policyId: String,
    public val productId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductPolicyPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceProductPolicyPlainArgs.builder()
            .format(format?.let({ args0 -> args0 }))
            .policyId(policyId.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceProductPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceProductPolicyPlainArgsBuilder internal constructor() {
    private var format: String? = null

    private var policyId: String? = null

    private var productId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value Policy Export Format.
     */
    @JvmName("cknrcjoodmnwdjhn")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("fpkwpegunxgqjrod")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyId = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hreotjnawhvhqane")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("drtwudfipymgxjrl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("biyqamxuxjuvkscv")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("qbhjhmkpkftpaths")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspaceProductPolicyPlainArgs = GetWorkspaceProductPolicyPlainArgs(
        format = format,
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
        productId = productId ?: throw PulumiNullFieldException("productId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
