@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.HostnameConfigurationArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.CertificateSource
import com.pulumi.azurenative.apimanagement.kotlin.enums.CertificateStatus
import com.pulumi.azurenative.apimanagement.kotlin.enums.HostnameType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom hostname configuration.
 * @property certificate Certificate information.
 * @property certificatePassword Certificate Password.
 * @property certificateSource Certificate Source.
 * @property certificateStatus Certificate Status.
 * @property defaultSslBinding Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to gateway Hostname Type.
 * @property encodedCertificate Base64 Encoded certificate.
 * @property hostName Hostname to configure on the Api Management service.
 * @property identityClientId System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
 * @property keyVaultId Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
 * @property negotiateClientCertificate Specify true to always negotiate client certificate on the hostname. Default Value is false.
 * @property type Hostname type.
 */
public data class HostnameConfigurationArgs(
    public val certificate: Output<CertificateInformationArgs>? = null,
    public val certificatePassword: Output<String>? = null,
    public val certificateSource: Output<Either<String, CertificateSource>>? = null,
    public val certificateStatus: Output<Either<String, CertificateStatus>>? = null,
    public val defaultSslBinding: Output<Boolean>? = null,
    public val encodedCertificate: Output<String>? = null,
    public val hostName: Output<String>,
    public val identityClientId: Output<String>? = null,
    public val keyVaultId: Output<String>? = null,
    public val negotiateClientCertificate: Output<Boolean>? = null,
    public val type: Output<Either<String, HostnameType>>,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.HostnameConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.HostnameConfigurationArgs =
        com.pulumi.azurenative.apimanagement.inputs.HostnameConfigurationArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .certificatePassword(certificatePassword?.applyValue({ args0 -> args0 }))
            .certificateSource(
                certificateSource?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .certificateStatus(
                certificateStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .defaultSslBinding(defaultSslBinding?.applyValue({ args0 -> args0 }))
            .encodedCertificate(encodedCertificate?.applyValue({ args0 -> args0 }))
            .hostName(hostName.applyValue({ args0 -> args0 }))
            .identityClientId(identityClientId?.applyValue({ args0 -> args0 }))
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .negotiateClientCertificate(negotiateClientCertificate?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HostnameConfigurationArgs].
 */
@PulumiTagMarker
public class HostnameConfigurationArgsBuilder internal constructor() {
    private var certificate: Output<CertificateInformationArgs>? = null

    private var certificatePassword: Output<String>? = null

    private var certificateSource: Output<Either<String, CertificateSource>>? = null

    private var certificateStatus: Output<Either<String, CertificateStatus>>? = null

    private var defaultSslBinding: Output<Boolean>? = null

    private var encodedCertificate: Output<String>? = null

    private var hostName: Output<String>? = null

    private var identityClientId: Output<String>? = null

    private var keyVaultId: Output<String>? = null

    private var negotiateClientCertificate: Output<Boolean>? = null

    private var type: Output<Either<String, HostnameType>>? = null

    /**
     * @param value Certificate information.
     */
    @JvmName("fyjydyieatmtaecq")
    public suspend fun certificate(`value`: Output<CertificateInformationArgs>) {
        this.certificate = value
    }

    /**
     * @param value Certificate Password.
     */
    @JvmName("mvvqhcvwvaotkwoy")
    public suspend fun certificatePassword(`value`: Output<String>) {
        this.certificatePassword = value
    }

    /**
     * @param value Certificate Source.
     */
    @JvmName("ofqurcftwwseclke")
    public suspend fun certificateSource(`value`: Output<Either<String, CertificateSource>>) {
        this.certificateSource = value
    }

    /**
     * @param value Certificate Status.
     */
    @JvmName("jjduoyjgwtdieayp")
    public suspend fun certificateStatus(`value`: Output<Either<String, CertificateStatus>>) {
        this.certificateStatus = value
    }

    /**
     * @param value Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to gateway Hostname Type.
     */
    @JvmName("bsbdfiyaqofjbwda")
    public suspend fun defaultSslBinding(`value`: Output<Boolean>) {
        this.defaultSslBinding = value
    }

    /**
     * @param value Base64 Encoded certificate.
     */
    @JvmName("lpcpomyanufmumyi")
    public suspend fun encodedCertificate(`value`: Output<String>) {
        this.encodedCertificate = value
    }

    /**
     * @param value Hostname to configure on the Api Management service.
     */
    @JvmName("cbantkyhgmfddont")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
     */
    @JvmName("veisnnlasqwbfcmn")
    public suspend fun identityClientId(`value`: Output<String>) {
        this.identityClientId = value
    }

    /**
     * @param value Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
     */
    @JvmName("yuqkpyrbffatygao")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value Specify true to always negotiate client certificate on the hostname. Default Value is false.
     */
    @JvmName("rekgewrepbhmkgpm")
    public suspend fun negotiateClientCertificate(`value`: Output<Boolean>) {
        this.negotiateClientCertificate = value
    }

    /**
     * @param value Hostname type.
     */
    @JvmName("hrrbfqvkxkqsrjhp")
    public suspend fun type(`value`: Output<Either<String, HostnameType>>) {
        this.type = value
    }

    /**
     * @param value Certificate information.
     */
    @JvmName("fwlsfilwkhauqmvx")
    public suspend fun certificate(`value`: CertificateInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Certificate information.
     */
    @JvmName("xfkkievvdnbkvcev")
    public suspend fun certificate(argument: suspend CertificateInformationArgsBuilder.() -> Unit) {
        val toBeMapped = CertificateInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Certificate Password.
     */
    @JvmName("tmtnfodcxsbkakoe")
    public suspend fun certificatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificatePassword = mapped
    }

    /**
     * @param value Certificate Source.
     */
    @JvmName("hbusmxawvwfbwmqo")
    public suspend fun certificateSource(`value`: Either<String, CertificateSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSource = mapped
    }

    /**
     * @param value Certificate Source.
     */
    @JvmName("tmjmwrwmjqdabijx")
    public fun certificateSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CertificateSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateSource = mapped
    }

    /**
     * @param value Certificate Source.
     */
    @JvmName("qdunqrxoxprqlidj")
    public fun certificateSource(`value`: CertificateSource) {
        val toBeMapped = Either.ofRight<String, CertificateSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateSource = mapped
    }

    /**
     * @param value Certificate Status.
     */
    @JvmName("yucihdvfywtmpwca")
    public suspend fun certificateStatus(`value`: Either<String, CertificateStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateStatus = mapped
    }

    /**
     * @param value Certificate Status.
     */
    @JvmName("dmmxxcxxesvofqxr")
    public fun certificateStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CertificateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateStatus = mapped
    }

    /**
     * @param value Certificate Status.
     */
    @JvmName("pkvldrvunkbjtlwt")
    public fun certificateStatus(`value`: CertificateStatus) {
        val toBeMapped = Either.ofRight<String, CertificateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateStatus = mapped
    }

    /**
     * @param value Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to gateway Hostname Type.
     */
    @JvmName("hgueeysjfpeclymw")
    public suspend fun defaultSslBinding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSslBinding = mapped
    }

    /**
     * @param value Base64 Encoded certificate.
     */
    @JvmName("lbwntrrcookbfpil")
    public suspend fun encodedCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedCertificate = mapped
    }

    /**
     * @param value Hostname to configure on the Api Management service.
     */
    @JvmName("ooeytsqyjwhaosrj")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
     */
    @JvmName("brlxwsrrvaqacrkq")
    public suspend fun identityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityClientId = mapped
    }

    /**
     * @param value Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
     */
    @JvmName("urgvjuaidijuudkg")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value Specify true to always negotiate client certificate on the hostname. Default Value is false.
     */
    @JvmName("mxyduvjgluxpkjwy")
    public suspend fun negotiateClientCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negotiateClientCertificate = mapped
    }

    /**
     * @param value Hostname type.
     */
    @JvmName("fkyjcgeavuieqqbf")
    public suspend fun type(`value`: Either<String, HostnameType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Hostname type.
     */
    @JvmName("vqldjbqfhcixndiy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HostnameType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Hostname type.
     */
    @JvmName("jekucphxhpbnnnhh")
    public fun type(`value`: HostnameType) {
        val toBeMapped = Either.ofRight<String, HostnameType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): HostnameConfigurationArgs = HostnameConfigurationArgs(
        certificate = certificate,
        certificatePassword = certificatePassword,
        certificateSource = certificateSource,
        certificateStatus = certificateStatus,
        defaultSslBinding = defaultSslBinding,
        encodedCertificate = encodedCertificate,
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        identityClientId = identityClientId,
        keyVaultId = keyVaultId,
        negotiateClientCertificate = negotiateClientCertificate,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
