@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ListAuthorizationServerSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authsid Identifier of the authorization server.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ListAuthorizationServerSecretsPlainArgs(
    public val authsid: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ListAuthorizationServerSecretsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ListAuthorizationServerSecretsPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.ListAuthorizationServerSecretsPlainArgs.builder()
            .authsid(authsid.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAuthorizationServerSecretsPlainArgs].
 */
@PulumiTagMarker
public class ListAuthorizationServerSecretsPlainArgsBuilder internal constructor() {
    private var authsid: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identifier of the authorization server.
     */
    @JvmName("xbspspqrjgpmjbvb")
    public suspend fun authsid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authsid = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqqjbirwgdeeivfe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jfnfsfvudmjakrub")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): ListAuthorizationServerSecretsPlainArgs =
        ListAuthorizationServerSecretsPlainArgs(
            authsid = authsid ?: throw PulumiNullFieldException("authsid"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
