@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ListWorkspacePolicyFragmentReferencesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id A resource identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property skip Number of records to skip.
 * @property top Number of records to return.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class ListWorkspacePolicyFragmentReferencesPlainArgs(
    public val id: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val skip: Int? = null,
    public val top: Int? = null,
    public val workspaceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ListWorkspacePolicyFragmentReferencesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ListWorkspacePolicyFragmentReferencesPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.ListWorkspacePolicyFragmentReferencesPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkspacePolicyFragmentReferencesPlainArgs].
 */
@PulumiTagMarker
public class ListWorkspacePolicyFragmentReferencesPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var skip: Int? = null

    private var top: Int? = null

    private var workspaceId: String? = null

    /**
     * @param value A resource identifier.
     */
    @JvmName("eknjxbrcdksntwnd")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ginlfrqdhioonhdh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ihowxjtpmofwwscd")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Number of records to skip.
     */
    @JvmName("gltchkgtftpdpjki")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value Number of records to return.
     */
    @JvmName("svdypckdduaftyss")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jnscpoprkrgphsac")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): ListWorkspacePolicyFragmentReferencesPlainArgs =
        ListWorkspacePolicyFragmentReferencesPlainArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
            skip = skip,
            top = top,
            workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
        )
}
