@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.PrivateEndpointConnectionRequestPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The connection state of the private endpoint connection.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 */
public data class PrivateEndpointConnectionRequestPropertiesArgs(
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.PrivateEndpointConnectionRequestPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.PrivateEndpointConnectionRequestPropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.PrivateEndpointConnectionRequestPropertiesArgs.builder()
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionRequestPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionRequestPropertiesArgsBuilder internal constructor() {
    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("muwlbhpcqwahtmtv")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("aotwwjwwmnolpocq")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("wmjwqlnqpmbaipbg")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateEndpointConnectionRequestPropertiesArgs =
        PrivateEndpointConnectionRequestPropertiesArgs(
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        )
}
