@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subscription key parameter names details.
 * @property header Subscription key header name.
 * @property query Subscription key query string parameter name.
 */
public data class SubscriptionKeyParameterNamesContractArgs(
    public val `header`: Output<String>? = null,
    public val query: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs.builder()
            .`header`(`header`?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionKeyParameterNamesContractArgs].
 */
@PulumiTagMarker
public class SubscriptionKeyParameterNamesContractArgsBuilder internal constructor() {
    private var `header`: Output<String>? = null

    private var query: Output<String>? = null

    /**
     * @param value Subscription key header name.
     */
    @JvmName("jyrkibixiuwimrnt")
    public suspend fun `header`(`value`: Output<String>) {
        this.`header` = value
    }

    /**
     * @param value Subscription key query string parameter name.
     */
    @JvmName("tejltbesmyltijdj")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Subscription key header name.
     */
    @JvmName("yqrkfjnygxfufbdb")
    public suspend fun `header`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Subscription key query string parameter name.
     */
    @JvmName("brkjbqiwqpbrpkrl")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    internal fun build(): SubscriptionKeyParameterNamesContractArgs =
        SubscriptionKeyParameterNamesContractArgs(
            `header` = `header`,
            query = query,
        )
}
