@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.WikiDocumentationContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Wiki documentation details.
 * @property documentationId Documentation Identifier
 */
public data class WikiDocumentationContractArgs(
    public val documentationId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.WikiDocumentationContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.WikiDocumentationContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.WikiDocumentationContractArgs.builder()
            .documentationId(documentationId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WikiDocumentationContractArgs].
 */
@PulumiTagMarker
public class WikiDocumentationContractArgsBuilder internal constructor() {
    private var documentationId: Output<String>? = null

    /**
     * @param value Documentation Identifier
     */
    @JvmName("kminfipiyicydswv")
    public suspend fun documentationId(`value`: Output<String>) {
        this.documentationId = value
    }

    /**
     * @param value Documentation Identifier
     */
    @JvmName("wmofdcnjebodqfnw")
    public suspend fun documentationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationId = mapped
    }

    internal fun build(): WikiDocumentationContractArgs = WikiDocumentationContractArgs(
        documentationId = documentationId,
    )
}
