@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity properties of the Api Management service resource.
 * @property principalId The principal id of the identity.
 * @property tenantId The client tenant id of the identity.
 * @property type The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
 * @property userAssignedIdentities The list of user identities associated with the resource. The user identity
 * dictionary key references will be ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
 *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class ApiManagementServiceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
    public val userAssignedIdentities: Map<String, UserIdentityPropertiesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ApiManagementServiceIdentityResponse):
            ApiManagementServiceIdentityResponse = ApiManagementServiceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.apimanagement.kotlin.outputs.UserIdentityPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
