@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Issue Comment Contract details.
 * @property createdDate Date and time when the comment was created.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property text Comment text.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userId A resource identifier for the user who left the comment.
 */
public data class GetApiIssueCommentResult(
    public val createdDate: String? = null,
    public val id: String,
    public val name: String,
    public val text: String,
    public val type: String,
    public val userId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiIssueCommentResult):
            GetApiIssueCommentResult = GetApiIssueCommentResult(
            createdDate = javaType.createdDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            text = javaType.text(),
            type = javaType.type(),
            userId = javaType.userId(),
        )
    }
}
