@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * API Operation details.
 * @property description Description of the operation. May include HTML formatting tags.
 * @property displayName Operation Name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property method A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
 * @property name The name of the resource
 * @property policies Operation Policies
 * @property request An entity containing request details.
 * @property responses Array of Operation responses.
 * @property templateParameters Collection of URL template parameters.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property urlTemplate Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
 */
public data class GetApiOperationResult(
    public val description: String? = null,
    public val displayName: String,
    public val id: String,
    public val method: String,
    public val name: String,
    public val policies: String? = null,
    public val request: RequestContractResponse? = null,
    public val responses: List<ResponseContractResponse>? = null,
    public val templateParameters: List<ParameterContractResponse>? = null,
    public val type: String,
    public val urlTemplate: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiOperationResult):
            GetApiOperationResult = GetApiOperationResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            id = javaType.id(),
            method = javaType.method(),
            name = javaType.name(),
            policies = javaType.policies().map({ args0 -> args0 }).orElse(null),
            request = javaType.request().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.RequestContractResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            responses = javaType.responses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ResponseContractResponse.Companion.toKotlin(args0)
                })
            }),
            templateParameters = javaType.templateParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            urlTemplate = javaType.urlTemplate(),
        )
    }
}
