@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Logger details.
 * @property credentials The name and SendRule connection string of the event hub for azureEventHub logger.
 * Instrumentation key for applicationInsights logger.
 * @property description Logger description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isBuffered Whether records are buffered in the logger before publishing. Default is assumed to be true.
 * @property loggerType Logger type.
 * @property name The name of the resource
 * @property resourceId Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLoggerResult(
    public val credentials: Map<String, String>? = null,
    public val description: String? = null,
    public val id: String,
    public val isBuffered: Boolean? = null,
    public val loggerType: String,
    public val name: String,
    public val resourceId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetLoggerResult):
            GetLoggerResult = GetLoggerResult(
            credentials = javaType.credentials().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isBuffered = javaType.isBuffered().map({ args0 -> args0 }).orElse(null),
            loggerType = javaType.loggerType(),
            name = javaType.name(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
