@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API OAuth2 Authentication settings details.
 * @property authorizationServerId OAuth authorization server identifier.
 * @property scope operations scope.
 */
public data class OAuth2AuthenticationSettingsContractResponse(
    public val authorizationServerId: String? = null,
    public val scope: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.OAuth2AuthenticationSettingsContractResponse):
            OAuth2AuthenticationSettingsContractResponse = OAuth2AuthenticationSettingsContractResponse(
            authorizationServerId = javaType.authorizationServerId().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
        )
    }
}
