@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Operation request/response representation details.
 * @property contentType Specifies a registered or custom content type for this representation, e.g. application/xml.
 * @property examples Exampled defined for the representation.
 * @property formParameters Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
 * @property schemaId Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
 * @property typeName Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
 */
public data class RepresentationContractResponse(
    public val contentType: String,
    public val examples: Map<String, ParameterExampleContractResponse>? = null,
    public val formParameters: List<ParameterContractResponse>? = null,
    public val schemaId: String? = null,
    public val typeName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.RepresentationContractResponse):
            RepresentationContractResponse = RepresentationContractResponse(
            contentType = javaType.contentType(),
            examples = javaType.examples().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterExampleContractResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            formParameters = javaType.formParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin(args0)
                })
            }),
            schemaId = javaType.schemaId().map({ args0 -> args0 }).orElse(null),
            typeName = javaType.typeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
