@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.CircuitBreakerPolicyResponse
import com.pulumi.azurenative.app.kotlin.outputs.HttpConnectionPoolResponse
import com.pulumi.azurenative.app.kotlin.outputs.HttpRetryPolicyResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.app.kotlin.outputs.TcpConnectionPoolResponse
import com.pulumi.azurenative.app.kotlin.outputs.TcpRetryPolicyResponse
import com.pulumi.azurenative.app.kotlin.outputs.TimeoutPolicyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.CircuitBreakerPolicyResponse.Companion.toKotlin as circuitBreakerPolicyResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.HttpConnectionPoolResponse.Companion.toKotlin as httpConnectionPoolResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.HttpRetryPolicyResponse.Companion.toKotlin as httpRetryPolicyResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.TcpConnectionPoolResponse.Companion.toKotlin as tcpConnectionPoolResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.TcpRetryPolicyResponse.Companion.toKotlin as tcpRetryPolicyResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.TimeoutPolicyResponse.Companion.toKotlin as timeoutPolicyResponseToKotlin

/**
 * Builder for [AppResiliency].
 */
@PulumiTagMarker
public class AppResiliencyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppResiliencyArgs = AppResiliencyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppResiliencyArgsBuilder.() -> Unit) {
        val builder = AppResiliencyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AppResiliency {
        val builtJavaResource = com.pulumi.azurenative.app.AppResiliency(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppResiliency(builtJavaResource)
    }
}

/**
 * Configuration to setup App Resiliency
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update App Resiliency
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appResiliency = new AzureNative.App.AppResiliency("appResiliency", new()
 *     {
 *         AppName = "testcontainerApp0",
 *         CircuitBreakerPolicy = new AzureNative.App.Inputs.CircuitBreakerPolicyArgs
 *         {
 *             ConsecutiveErrors = 5,
 *             IntervalInSeconds = 10,
 *             MaxEjectionPercent = 50,
 *         },
 *         HttpConnectionPool = new AzureNative.App.Inputs.HttpConnectionPoolArgs
 *         {
 *             Http1MaxPendingRequests = 1024,
 *             Http2MaxRequests = 1024,
 *         },
 *         HttpRetryPolicy = new AzureNative.App.Inputs.HttpRetryPolicyArgs
 *         {
 *             Errors = new[]
 *             {
 *                 "5xx",
 *                 "connect-failure",
 *                 "reset",
 *                 "retriable-headers",
 *                 "retriable-status-codes",
 *             },
 *             Headers = new[]
 *             {
 *                 new AzureNative.App.Inputs.HeaderMatchArgs
 *                 {
 *                     Header = "X-Content-Type",
 *                     PrefixMatch = "GOATS",
 *                 },
 *             },
 *             HttpStatusCodes = new[]
 *             {
 *                 502,
 *                 503,
 *             },
 *             InitialDelayInMilliseconds = 1000,
 *             MaxIntervalInMilliseconds = 10000,
 *             MaxRetries = 5,
 *         },
 *         Name = "resiliency-policy-1",
 *         ResourceGroupName = "rg",
 *         TcpConnectionPool = new AzureNative.App.Inputs.TcpConnectionPoolArgs
 *         {
 *             MaxConnections = 100,
 *         },
 *         TcpRetryPolicy = new AzureNative.App.Inputs.TcpRetryPolicyArgs
 *         {
 *             MaxConnectAttempts = 3,
 *         },
 *         TimeoutPolicy = new AzureNative.App.Inputs.TimeoutPolicyArgs
 *         {
 *             ConnectionTimeoutInSeconds = 5,
 *             ResponseTimeoutInSeconds = 15,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewAppResiliency(ctx, "appResiliency", &app.AppResiliencyArgs{
 * 			AppName: pulumi.String("testcontainerApp0"),
 * 			CircuitBreakerPolicy: &app.CircuitBreakerPolicyArgs{
 * 				ConsecutiveErrors:  pulumi.Int(5),
 * 				IntervalInSeconds:  pulumi.Int(10),
 * 				MaxEjectionPercent: pulumi.Int(50),
 * 			},
 * 			HttpConnectionPool: &app.HttpConnectionPoolArgs{
 * 				Http1MaxPendingRequests: pulumi.Int(1024),
 * 				Http2MaxRequests:        pulumi.Int(1024),
 * 			},
 * 			HttpRetryPolicy: app.HttpRetryPolicyResponse{
 * 				Errors: pulumi.StringArray{
 * 					pulumi.String("5xx"),
 * 					pulumi.String("connect-failure"),
 * 					pulumi.String("reset"),
 * 					pulumi.String("retriable-headers"),
 * 					pulumi.String("retriable-status-codes"),
 * 				},
 * 				Headers: app.HeaderMatchArray{
 * 					&app.HeaderMatchArgs{
 * 						Header:      pulumi.String("X-Content-Type"),
 * 						PrefixMatch: pulumi.String("GOATS"),
 * 					},
 * 				},
 * 				HttpStatusCodes: pulumi.IntArray{
 * 					pulumi.Int(502),
 * 					pulumi.Int(503),
 * 				},
 * 				InitialDelayInMilliseconds: pulumi.Float64(1000),
 * 				MaxIntervalInMilliseconds:  pulumi.Float64(10000),
 * 				MaxRetries:                 pulumi.Int(5),
 * 			},
 * 			Name:              pulumi.String("resiliency-policy-1"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			TcpConnectionPool: &app.TcpConnectionPoolArgs{
 * 				MaxConnections: pulumi.Int(100),
 * 			},
 * 			TcpRetryPolicy: &app.TcpRetryPolicyArgs{
 * 				MaxConnectAttempts: pulumi.Int(3),
 * 			},
 * 			TimeoutPolicy: &app.TimeoutPolicyArgs{
 * 				ConnectionTimeoutInSeconds: pulumi.Int(5),
 * 				ResponseTimeoutInSeconds:   pulumi.Int(15),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.AppResiliency;
 * import com.pulumi.azurenative.app.AppResiliencyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appResiliency = new AppResiliency("appResiliency", AppResiliencyArgs.builder()
 *             .appName("testcontainerApp0")
 *             .circuitBreakerPolicy(Map.ofEntries(
 *                 Map.entry("consecutiveErrors", 5),
 *                 Map.entry("intervalInSeconds", 10),
 *                 Map.entry("maxEjectionPercent", 50)
 *             ))
 *             .httpConnectionPool(Map.ofEntries(
 *                 Map.entry("http1MaxPendingRequests", 1024),
 *                 Map.entry("http2MaxRequests", 1024)
 *             ))
 *             .httpRetryPolicy(Map.ofEntries(
 *                 Map.entry("errors",
 *                     "5xx",
 *                     "connect-failure",
 *                     "reset",
 *                     "retriable-headers",
 *                     "retriable-status-codes"),
 *                 Map.entry("headers", Map.ofEntries(
 *                     Map.entry("header", "X-Content-Type"),
 *                     Map.entry("prefixMatch", "GOATS")
 *                 )),
 *                 Map.entry("httpStatusCodes",
 *                     502,
 *                     503),
 *                 Map.entry("initialDelayInMilliseconds", 1000),
 *                 Map.entry("maxIntervalInMilliseconds", 10000),
 *                 Map.entry("maxRetries", 5)
 *             ))
 *             .name("resiliency-policy-1")
 *             .resourceGroupName("rg")
 *             .tcpConnectionPool(Map.of("maxConnections", 100))
 *             .tcpRetryPolicy(Map.of("maxConnectAttempts", 3))
 *             .timeoutPolicy(Map.ofEntries(
 *                 Map.entry("connectionTimeoutInSeconds", 5),
 *                 Map.entry("responseTimeoutInSeconds", 15)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:AppResiliency resiliency-policy-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies/{name}
 * ```
 */
public class AppResiliency internal constructor(
    override val javaResource: com.pulumi.azurenative.app.AppResiliency,
) : KotlinCustomResource(javaResource, AppResiliencyMapper) {
    /**
     * Policy that defines circuit breaker conditions
     */
    public val circuitBreakerPolicy: Output<CircuitBreakerPolicyResponse>?
        get() = javaResource.circuitBreakerPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> circuitBreakerPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Defines parameters for http connection pooling
     */
    public val httpConnectionPool: Output<HttpConnectionPoolResponse>?
        get() = javaResource.httpConnectionPool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> httpConnectionPoolResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Policy that defines http request retry conditions
     */
    public val httpRetryPolicy: Output<HttpRetryPolicyResponse>?
        get() = javaResource.httpRetryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> httpRetryPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Defines parameters for tcp connection pooling
     */
    public val tcpConnectionPool: Output<TcpConnectionPoolResponse>?
        get() = javaResource.tcpConnectionPool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> tcpConnectionPoolResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Policy that defines tcp request retry conditions
     */
    public val tcpRetryPolicy: Output<TcpRetryPolicyResponse>?
        get() = javaResource.tcpRetryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> tcpRetryPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Policy to set request timeouts
     */
    public val timeoutPolicy: Output<TimeoutPolicyResponse>?
        get() = javaResource.timeoutPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeoutPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppResiliencyMapper : ResourceMapper<AppResiliency> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.AppResiliency::class == javaResource::class

    override fun map(javaResource: Resource): AppResiliency = AppResiliency(
        javaResource as
            com.pulumi.azurenative.app.AppResiliency,
    )
}

/**
 * @see [AppResiliency].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppResiliency].
 */
public suspend fun appResiliency(
    name: String,
    block: suspend AppResiliencyResourceBuilder.() -> Unit,
): AppResiliency {
    val builder = AppResiliencyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppResiliency].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appResiliency(name: String): AppResiliency {
    val builder = AppResiliencyResourceBuilder()
    builder.name(name)
    return builder.build()
}
