@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.BuildConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.ContainerRegistryWithCustomImageResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.BuildConfigurationResponse.Companion.toKotlin as buildConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ContainerRegistryWithCustomImageResponse.Companion.toKotlin as containerRegistryWithCustomImageResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Build].
 */
@PulumiTagMarker
public class BuildResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuildArgs = BuildArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuildArgsBuilder.() -> Unit) {
        val builder = BuildArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Build {
        val builtJavaResource = com.pulumi.azurenative.app.Build(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Build(builtJavaResource)
    }
}

/**
 * Information pertaining to an individual build.
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Example Usage
 * ### Builds_CreateOrUpdate_NoConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var build = new AzureNative.App.Build("build", new()
 *     {
 *         BuildName = "testBuild",
 *         BuilderName = "testBuilder",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewBuild(ctx, "build", &app.BuildArgs{
 * 			BuildName:         pulumi.String("testBuild"),
 * 			BuilderName:       pulumi.String("testBuilder"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Build;
 * import com.pulumi.azurenative.app.BuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var build = new Build("build", BuildArgs.builder()
 *             .buildName("testBuild")
 *             .builderName("testBuilder")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Builds_CreateOrUpdate_WithConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var build = new AzureNative.App.Build("build", new()
 *     {
 *         BuildName = "testBuild-123456789az",
 *         BuilderName = "testBuilder",
 *         Configuration = new AzureNative.App.Inputs.BuildConfigurationArgs
 *         {
 *             BaseOs = "DebianBullseye",
 *             EnvironmentVariables = new[]
 *             {
 *                 new AzureNative.App.Inputs.EnvironmentVariableArgs
 *                 {
 *                     Name = "foo1",
 *                     Value = "bar1",
 *                 },
 *                 new AzureNative.App.Inputs.EnvironmentVariableArgs
 *                 {
 *                     Name = "foo2",
 *                     Value = "bar2",
 *                 },
 *             },
 *             Platform = "dotnetcore",
 *             PlatformVersion = "7.0",
 *             PreBuildSteps = new[]
 *             {
 *                 new AzureNative.App.Inputs.PreBuildStepArgs
 *                 {
 *                     Description = "First pre build step.",
 *                     HttpGet = new AzureNative.App.Inputs.HttpGetArgs
 *                     {
 *                         FileName = "output.txt",
 *                         Headers = new[]
 *                         {
 *                             "foo",
 *                             "bar",
 *                         },
 *                         Url = "https://microsoft.com",
 *                     },
 *                     Scripts = new[]
 *                     {
 *                         "echo 'hello'",
 *                         "echo 'world'",
 *                     },
 *                 },
 *                 new AzureNative.App.Inputs.PreBuildStepArgs
 *                 {
 *                     Description = "Second pre build step.",
 *                     HttpGet = new AzureNative.App.Inputs.HttpGetArgs
 *                     {
 *                         FileName = "output.txt",
 *                         Headers = new[]
 *                         {
 *                             "foo",
 *                         },
 *                         Url = "https://microsoft.com",
 *                     },
 *                     Scripts = new[]
 *                     {
 *                         "echo 'hello'",
 *                         "echo 'again'",
 *                     },
 *                 },
 *             },
 *         },
 *         DestinationContainerRegistry = new AzureNative.App.Inputs.ContainerRegistryWithCustomImageArgs
 *         {
 *             Image = "test.azurecr.io/repo:tag",
 *             Server = "test.azurecr.io",
 *         },
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewBuild(ctx, "build", &app.BuildArgs{
 * BuildName: pulumi.String("testBuild-123456789az"),
 * BuilderName: pulumi.String("testBuilder"),
 * Configuration: app.BuildConfigurationResponse{
 * BaseOs: pulumi.String("DebianBullseye"),
 * EnvironmentVariables: app.EnvironmentVariableArray{
 * &app.EnvironmentVariableArgs{
 * Name: pulumi.String("foo1"),
 * Value: pulumi.String("bar1"),
 * },
 * &app.EnvironmentVariableArgs{
 * Name: pulumi.String("foo2"),
 * Value: pulumi.String("bar2"),
 * },
 * },
 * Platform: pulumi.String("dotnetcore"),
 * PlatformVersion: pulumi.String("7.0"),
 * PreBuildSteps: app.PreBuildStepArray{
 * interface{}{
 * Description: pulumi.String("First pre build step."),
 * HttpGet: &app.HttpGetArgs{
 * FileName: pulumi.String("output.txt"),
 * Headers: pulumi.StringArray{
 * pulumi.String("foo"),
 * pulumi.String("bar"),
 * },
 * Url: pulumi.String("https://microsoft.com"),
 * },
 * Scripts: pulumi.StringArray{
 * pulumi.String("echo 'hello'"),
 * pulumi.String("echo 'world'"),
 * },
 * },
 * interface{}{
 * Description: pulumi.String("Second pre build step."),
 * HttpGet: &app.HttpGetArgs{
 * FileName: pulumi.String("output.txt"),
 * Headers: pulumi.StringArray{
 * pulumi.String("foo"),
 * },
 * Url: pulumi.String("https://microsoft.com"),
 * },
 * Scripts: pulumi.StringArray{
 * pulumi.String("echo 'hello'"),
 * pulumi.String("echo 'again'"),
 * },
 * },
 * },
 * },
 * DestinationContainerRegistry: &app.ContainerRegistryWithCustomImageArgs{
 * Image: pulumi.String("test.azurecr.io/repo:tag"),
 * Server: pulumi.String("test.azurecr.io"),
 * },
 * ResourceGroupName: pulumi.String("rg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Build;
 * import com.pulumi.azurenative.app.BuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var build = new Build("build", BuildArgs.builder()
 *             .buildName("testBuild-123456789az")
 *             .builderName("testBuilder")
 *             .configuration(Map.ofEntries(
 *                 Map.entry("baseOs", "DebianBullseye"),
 *                 Map.entry("environmentVariables",
 *                     Map.ofEntries(
 *                         Map.entry("name", "foo1"),
 *                         Map.entry("value", "bar1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "foo2"),
 *                         Map.entry("value", "bar2")
 *                     )),
 *                 Map.entry("platform", "dotnetcore"),
 *                 Map.entry("platformVersion", "7.0"),
 *                 Map.entry("preBuildSteps",
 *                     Map.ofEntries(
 *                         Map.entry("description", "First pre build step."),
 *                         Map.entry("httpGet", Map.ofEntries(
 *                             Map.entry("fileName", "output.txt"),
 *                             Map.entry("headers",
 *                                 "foo",
 *                                 "bar"),
 *                             Map.entry("url", "https://microsoft.com")
 *                         )),
 *                         Map.entry("scripts",
 *                             "echo 'hello'",
 *                             "echo 'world'")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Second pre build step."),
 *                         Map.entry("httpGet", Map.ofEntries(
 *                             Map.entry("fileName", "output.txt"),
 *                             Map.entry("headers", "foo"),
 *                             Map.entry("url", "https://microsoft.com")
 *                         )),
 *                         Map.entry("scripts",
 *                             "echo 'hello'",
 *                             "echo 'again'")
 *                     ))
 *             ))
 *             .destinationContainerRegistry(Map.ofEntries(
 *                 Map.entry("image", "test.azurecr.io/repo:tag"),
 *                 Map.entry("server", "test.azurecr.io")
 *             ))
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Build testBuild-123456789az /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/builders/{builderName}/builds/{buildName}
 * ```
 */
public class Build internal constructor(
    override val javaResource: com.pulumi.azurenative.app.Build,
) : KotlinCustomResource(javaResource, BuildMapper) {
    /**
     * Status of the build once it has been provisioned.
     */
    public val buildStatus: Output<String>
        get() = javaResource.buildStatus().applyValue({ args0 -> args0 })

    /**
     * Configuration of the build.
     */
    public val configuration: Output<BuildConfigurationResponse>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> buildConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Container registry that the final image will be uploaded to.
     */
    public val destinationContainerRegistry: Output<ContainerRegistryWithCustomImageResponse>?
        get() = javaResource.destinationContainerRegistry().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerRegistryWithCustomImageResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Endpoint from which the build logs can be streamed.
     */
    public val logStreamEndpoint: Output<String>
        get() = javaResource.logStreamEndpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Build provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Endpoint to use to retrieve an authentication token for log streaming and uploading source code.
     */
    public val tokenEndpoint: Output<String>
        get() = javaResource.tokenEndpoint().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Endpoint to which the source code should be uploaded.
     */
    public val uploadEndpoint: Output<String>
        get() = javaResource.uploadEndpoint().applyValue({ args0 -> args0 })
}

public object BuildMapper : ResourceMapper<Build> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.Build::class == javaResource::class

    override fun map(javaResource: Resource): Build = Build(
        javaResource as
            com.pulumi.azurenative.app.Build,
    )
}

/**
 * @see [Build].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Build].
 */
public suspend fun build(name: String, block: suspend BuildResourceBuilder.() -> Unit): Build {
    val builder = BuildResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Build].
 * @param name The _unique_ name of the resulting resource.
 */
public fun build(name: String): Build {
    val builder = BuildResourceBuilder()
    builder.name(name)
    return builder.build()
}
