@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ConnectedEnvironmentArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.CustomDomainConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.CustomDomainConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.app.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An environment for Kubernetes cluster specialized for web workloads by Azure App Service
 * Azure REST API version: 2022-10-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create kube environments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedEnvironment = new AzureNative.App.ConnectedEnvironment("connectedEnvironment", new()
 *     {
 *         ConnectedEnvironmentName = "testenv",
 *         CustomDomainConfiguration = new AzureNative.App.Inputs.CustomDomainConfigurationArgs
 *         {
 *             CertificatePassword = "private key password",
 *             CertificateValue = "Y2VydA==",
 *             DnsSuffix = "www.my-name.com",
 *         },
 *         DaprAIConnectionString = "InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/",
 *         ExtendedLocation = new AzureNative.App.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/examplerg/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "examplerg",
 *         StaticIp = "1.2.3.4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewConnectedEnvironment(ctx, "connectedEnvironment", &app.ConnectedEnvironmentArgs{
 * 			ConnectedEnvironmentName: pulumi.String("testenv"),
 * 			CustomDomainConfiguration: &app.CustomDomainConfigurationArgs{
 * 				CertificatePassword: pulumi.String("private key password"),
 * 				CertificateValue:    pulumi.String("Y2VydA=="),
 * 				DnsSuffix:           pulumi.String("www.my-name.com"),
 * 			},
 * 			DaprAIConnectionString: pulumi.String("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/"),
 * 			ExtendedLocation: &app.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/examplerg/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			StaticIp:          pulumi.String("1.2.3.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ConnectedEnvironment;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedEnvironment = new ConnectedEnvironment("connectedEnvironment", ConnectedEnvironmentArgs.builder()
 *             .connectedEnvironmentName("testenv")
 *             .customDomainConfiguration(Map.ofEntries(
 *                 Map.entry("certificatePassword", "private key password"),
 *                 Map.entry("certificateValue", "Y2VydA=="),
 *                 Map.entry("dnsSuffix", "www.my-name.com")
 *             ))
 *             .daprAIConnectionString("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/examplerg/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("East US")
 *             .resourceGroupName("examplerg")
 *             .staticIp("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ConnectedEnvironment testenv /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}
 * ```
 * @property connectedEnvironmentName Name of the connectedEnvironment.
 * @property customDomainConfiguration Custom domain configuration for the environment
 * @property daprAIConnectionString Application Insights connection string used by Dapr to export Service to Service communication telemetry
 * @property extendedLocation The complex type of the extended location.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property staticIp Static IP of the connectedEnvironment
 * @property tags Resource tags.
 */
public data class ConnectedEnvironmentArgs(
    public val connectedEnvironmentName: Output<String>? = null,
    public val customDomainConfiguration: Output<CustomDomainConfigurationArgs>? = null,
    public val daprAIConnectionString: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val staticIp: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ConnectedEnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ConnectedEnvironmentArgs =
        com.pulumi.azurenative.app.ConnectedEnvironmentArgs.builder()
            .connectedEnvironmentName(connectedEnvironmentName?.applyValue({ args0 -> args0 }))
            .customDomainConfiguration(
                customDomainConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .daprAIConnectionString(daprAIConnectionString?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .staticIp(staticIp?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectedEnvironmentArgs].
 */
@PulumiTagMarker
public class ConnectedEnvironmentArgsBuilder internal constructor() {
    private var connectedEnvironmentName: Output<String>? = null

    private var customDomainConfiguration: Output<CustomDomainConfigurationArgs>? = null

    private var daprAIConnectionString: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var staticIp: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the connectedEnvironment.
     */
    @JvmName("rkrprehrryakjumg")
    public suspend fun connectedEnvironmentName(`value`: Output<String>) {
        this.connectedEnvironmentName = value
    }

    /**
     * @param value Custom domain configuration for the environment
     */
    @JvmName("pebkjcrudofupqjy")
    public suspend fun customDomainConfiguration(`value`: Output<CustomDomainConfigurationArgs>) {
        this.customDomainConfiguration = value
    }

    /**
     * @param value Application Insights connection string used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("yacshsrdeexldewi")
    public suspend fun daprAIConnectionString(`value`: Output<String>) {
        this.daprAIConnectionString = value
    }

    /**
     * @param value The complex type of the extended location.
     */
    @JvmName("qabyoludwgajeilj")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wlgwmhlrirnftjca")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ppljnwoeiuepyuhq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Static IP of the connectedEnvironment
     */
    @JvmName("cwwiskgkdxaqsler")
    public suspend fun staticIp(`value`: Output<String>) {
        this.staticIp = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yuuaedtfowneqjag")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the connectedEnvironment.
     */
    @JvmName("fcytycfjsfxiwvgo")
    public suspend fun connectedEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedEnvironmentName = mapped
    }

    /**
     * @param value Custom domain configuration for the environment
     */
    @JvmName("ivsqaskcwmamfwua")
    public suspend fun customDomainConfiguration(`value`: CustomDomainConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomainConfiguration = mapped
    }

    /**
     * @param argument Custom domain configuration for the environment
     */
    @JvmName("piplqxdwonclnnkd")
    public suspend
    fun customDomainConfiguration(argument: suspend CustomDomainConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomDomainConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDomainConfiguration = mapped
    }

    /**
     * @param value Application Insights connection string used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("btfthergvyddtjfd")
    public suspend fun daprAIConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daprAIConnectionString = mapped
    }

    /**
     * @param value The complex type of the extended location.
     */
    @JvmName("mwgggnfqhjroavbu")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The complex type of the extended location.
     */
    @JvmName("llqmhutxhccusrtd")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sfqxclmtmqkjptah")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("niuaqjpvluvmfkhg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Static IP of the connectedEnvironment
     */
    @JvmName("jngyipidenumxfyj")
    public suspend fun staticIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIp = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cdntnrwqgeutlroy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("etafqgpmfnbktkrn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectedEnvironmentArgs = ConnectedEnvironmentArgs(
        connectedEnvironmentName = connectedEnvironmentName,
        customDomainConfiguration = customDomainConfiguration,
        daprAIConnectionString = daprAIConnectionString,
        extendedLocation = extendedLocation,
        location = location,
        resourceGroupName = resourceGroupName,
        staticIp = staticIp,
        tags = tags,
    )
}
