@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.CertificateResponseProperties
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.CertificateResponseProperties.Companion.toKotlin as certificateResponsePropertiesToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectedEnvironmentsCertificate].
 */
@PulumiTagMarker
public class ConnectedEnvironmentsCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectedEnvironmentsCertificateArgs = ConnectedEnvironmentsCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectedEnvironmentsCertificateArgsBuilder.() -> Unit) {
        val builder = ConnectedEnvironmentsCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectedEnvironmentsCertificate {
        val builtJavaResource =
            com.pulumi.azurenative.app.ConnectedEnvironmentsCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectedEnvironmentsCertificate(builtJavaResource)
    }
}

/**
 * Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
 * Azure REST API version: 2022-10-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedEnvironmentsCertificate = new AzureNative.App.ConnectedEnvironmentsCertificate("connectedEnvironmentsCertificate", new()
 *     {
 *         CertificateName = "certificate-firendly-name",
 *         ConnectedEnvironmentName = "testcontainerenv",
 *         Location = "East US",
 *         Properties = new AzureNative.App.Inputs.CertificatePropertiesArgs
 *         {
 *             Password = "private key password",
 *             Value = "Y2VydA==",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewConnectedEnvironmentsCertificate(ctx, "connectedEnvironmentsCertificate", &app.ConnectedEnvironmentsCertificateArgs{
 * 			CertificateName:          pulumi.String("certificate-firendly-name"),
 * 			ConnectedEnvironmentName: pulumi.String("testcontainerenv"),
 * 			Location:                 pulumi.String("East US"),
 * 			Properties: &app.CertificatePropertiesArgs{
 * 				Password: pulumi.String("private key password"),
 * 				Value:    pulumi.String("Y2VydA=="),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentsCertificate;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentsCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedEnvironmentsCertificate = new ConnectedEnvironmentsCertificate("connectedEnvironmentsCertificate", ConnectedEnvironmentsCertificateArgs.builder()
 *             .certificateName("certificate-firendly-name")
 *             .connectedEnvironmentName("testcontainerenv")
 *             .location("East US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("password", "private key password"),
 *                 Map.entry("value", "Y2VydA==")
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ConnectedEnvironmentsCertificate myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/certificates/{certificateName}
 * ```
 */
public class ConnectedEnvironmentsCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ConnectedEnvironmentsCertificate,
) : KotlinCustomResource(javaResource, ConnectedEnvironmentsCertificateMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Certificate resource specific properties
     */
    public val properties: Output<CertificateResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                certificateResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectedEnvironmentsCertificateMapper :
    ResourceMapper<ConnectedEnvironmentsCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ConnectedEnvironmentsCertificate::class == javaResource::class

    override fun map(javaResource: Resource): ConnectedEnvironmentsCertificate =
        ConnectedEnvironmentsCertificate(
            javaResource as
                com.pulumi.azurenative.app.ConnectedEnvironmentsCertificate,
        )
}

/**
 * @see [ConnectedEnvironmentsCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectedEnvironmentsCertificate].
 */
public suspend fun connectedEnvironmentsCertificate(
    name: String,
    block: suspend ConnectedEnvironmentsCertificateResourceBuilder.() -> Unit,
):
    ConnectedEnvironmentsCertificate {
    val builder = ConnectedEnvironmentsCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectedEnvironmentsCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectedEnvironmentsCertificate(name: String): ConnectedEnvironmentsCertificate {
    val builder = ConnectedEnvironmentsCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
