@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.DaprComponentArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.DaprMetadataArgs
import com.pulumi.azurenative.app.kotlin.inputs.DaprMetadataArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.SecretArgs
import com.pulumi.azurenative.app.kotlin.inputs.SecretArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dapr Component.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create or update dapr component with secret store component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponent = new AzureNative.App.DaprComponent("daprComponent", new()
 *     {
 *         ComponentName = "reddog",
 *         ComponentType = "state.azure.cosmosdb",
 *         EnvironmentName = "myenvironment",
 *         IgnoreErrors = false,
 *         InitTimeout = "50s",
 *         Metadata = new[]
 *         {
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "url",
 *                 Value = "<COSMOS-URL>",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "database",
 *                 Value = "itemsDB",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "collection",
 *                 Value = "items",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "masterkey",
 *                 SecretRef = "masterkey",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         Scopes = new[]
 *         {
 *             "container-app-1",
 *             "container-app-2",
 *         },
 *         SecretStoreComponent = "my-secret-store",
 *         Version = "v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprComponent(ctx, "daprComponent", &app.DaprComponentArgs{
 * 			ComponentName:   pulumi.String("reddog"),
 * 			ComponentType:   pulumi.String("state.azure.cosmosdb"),
 * 			EnvironmentName: pulumi.String("myenvironment"),
 * 			IgnoreErrors:    pulumi.Bool(false),
 * 			InitTimeout:     pulumi.String("50s"),
 * 			Metadata: []app.DaprMetadataArgs{
 * 				{
 * 					Name:  pulumi.String("url"),
 * 					Value: pulumi.String("<COSMOS-URL>"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("database"),
 * 					Value: pulumi.String("itemsDB"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("collection"),
 * 					Value: pulumi.String("items"),
 * 				},
 * 				{
 * 					Name:      pulumi.String("masterkey"),
 * 					SecretRef: pulumi.String("masterkey"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("container-app-1"),
 * 				pulumi.String("container-app-2"),
 * 			},
 * 			SecretStoreComponent: pulumi.String("my-secret-store"),
 * 			Version:              pulumi.String("v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponent;
 * import com.pulumi.azurenative.app.DaprComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponent = new DaprComponent("daprComponent", DaprComponentArgs.builder()
 *             .componentName("reddog")
 *             .componentType("state.azure.cosmosdb")
 *             .environmentName("myenvironment")
 *             .ignoreErrors(false)
 *             .initTimeout("50s")
 *             .metadata(
 *                 Map.ofEntries(
 *                     Map.entry("name", "url"),
 *                     Map.entry("value", "<COSMOS-URL>")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "database"),
 *                     Map.entry("value", "itemsDB")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "collection"),
 *                     Map.entry("value", "items")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "masterkey"),
 *                     Map.entry("secretRef", "masterkey")
 *                 ))
 *             .resourceGroupName("examplerg")
 *             .scopes(
 *                 "container-app-1",
 *                 "container-app-2")
 *             .secretStoreComponent("my-secret-store")
 *             .version("v1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr component with secrets
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponent = new AzureNative.App.DaprComponent("daprComponent", new()
 *     {
 *         ComponentName = "reddog",
 *         ComponentType = "state.azure.cosmosdb",
 *         EnvironmentName = "myenvironment",
 *         IgnoreErrors = false,
 *         InitTimeout = "50s",
 *         Metadata = new[]
 *         {
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "url",
 *                 Value = "<COSMOS-URL>",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "database",
 *                 Value = "itemsDB",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "collection",
 *                 Value = "items",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "masterkey",
 *                 SecretRef = "masterkey",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         Scopes = new[]
 *         {
 *             "container-app-1",
 *             "container-app-2",
 *         },
 *         Secrets = new[]
 *         {
 *             new AzureNative.App.Inputs.SecretArgs
 *             {
 *                 Name = "masterkey",
 *                 Value = "keyvalue",
 *             },
 *         },
 *         Version = "v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprComponent(ctx, "daprComponent", &app.DaprComponentArgs{
 * 			ComponentName:   pulumi.String("reddog"),
 * 			ComponentType:   pulumi.String("state.azure.cosmosdb"),
 * 			EnvironmentName: pulumi.String("myenvironment"),
 * 			IgnoreErrors:    pulumi.Bool(false),
 * 			InitTimeout:     pulumi.String("50s"),
 * 			Metadata: []app.DaprMetadataArgs{
 * 				{
 * 					Name:  pulumi.String("url"),
 * 					Value: pulumi.String("<COSMOS-URL>"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("database"),
 * 					Value: pulumi.String("itemsDB"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("collection"),
 * 					Value: pulumi.String("items"),
 * 				},
 * 				{
 * 					Name:      pulumi.String("masterkey"),
 * 					SecretRef: pulumi.String("masterkey"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("container-app-1"),
 * 				pulumi.String("container-app-2"),
 * 			},
 * 			Secrets: []app.SecretArgs{
 * 				{
 * 					Name:  pulumi.String("masterkey"),
 * 					Value: pulumi.String("keyvalue"),
 * 				},
 * 			},
 * 			Version: pulumi.String("v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponent;
 * import com.pulumi.azurenative.app.DaprComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponent = new DaprComponent("daprComponent", DaprComponentArgs.builder()
 *             .componentName("reddog")
 *             .componentType("state.azure.cosmosdb")
 *             .environmentName("myenvironment")
 *             .ignoreErrors(false)
 *             .initTimeout("50s")
 *             .metadata(
 *                 Map.ofEntries(
 *                     Map.entry("name", "url"),
 *                     Map.entry("value", "<COSMOS-URL>")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "database"),
 *                     Map.entry("value", "itemsDB")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "collection"),
 *                     Map.entry("value", "items")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "masterkey"),
 *                     Map.entry("secretRef", "masterkey")
 *                 ))
 *             .resourceGroupName("examplerg")
 *             .scopes(
 *                 "container-app-1",
 *                 "container-app-2")
 *             .secrets(Map.ofEntries(
 *                 Map.entry("name", "masterkey"),
 *                 Map.entry("value", "keyvalue")
 *             ))
 *             .version("v1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DaprComponent reddog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/daprComponents/{componentName}
 * ```
 * @property componentName Name of the Dapr Component.
 * @property componentType Component type
 * @property environmentName Name of the Managed Environment.
 * @property ignoreErrors Boolean describing if the component errors are ignores
 * @property initTimeout Initialization timeout
 * @property metadata Component metadata
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopes Names of container apps that can use this Dapr component
 * @property secretStoreComponent Name of a Dapr component to retrieve component secrets from
 * @property secrets Collection of secrets used by a Dapr component
 * @property version Component version
 */
public data class DaprComponentArgs(
    public val componentName: Output<String>? = null,
    public val componentType: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val ignoreErrors: Output<Boolean>? = null,
    public val initTimeout: Output<String>? = null,
    public val metadata: Output<List<DaprMetadataArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
    public val secretStoreComponent: Output<String>? = null,
    public val secrets: Output<List<SecretArgs>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.DaprComponentArgs> {
    override fun toJava(): com.pulumi.azurenative.app.DaprComponentArgs =
        com.pulumi.azurenative.app.DaprComponentArgs.builder()
            .componentName(componentName?.applyValue({ args0 -> args0 }))
            .componentType(componentType?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .ignoreErrors(ignoreErrors?.applyValue({ args0 -> args0 }))
            .initTimeout(initTimeout?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .secretStoreComponent(secretStoreComponent?.applyValue({ args0 -> args0 }))
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprComponentArgs].
 */
@PulumiTagMarker
public class DaprComponentArgsBuilder internal constructor() {
    private var componentName: Output<String>? = null

    private var componentType: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var ignoreErrors: Output<Boolean>? = null

    private var initTimeout: Output<String>? = null

    private var metadata: Output<List<DaprMetadataArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    private var secretStoreComponent: Output<String>? = null

    private var secrets: Output<List<SecretArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("dcxvympnyfggtsaa")
    public suspend fun componentName(`value`: Output<String>) {
        this.componentName = value
    }

    /**
     * @param value Component type
     */
    @JvmName("lkvovjmqrstouhdk")
    public suspend fun componentType(`value`: Output<String>) {
        this.componentType = value
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("tyjcvjlwpfvdygmn")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Boolean describing if the component errors are ignores
     */
    @JvmName("mmcxxupxobrbbulj")
    public suspend fun ignoreErrors(`value`: Output<Boolean>) {
        this.ignoreErrors = value
    }

    /**
     * @param value Initialization timeout
     */
    @JvmName("rpsbrhancjgpxtsw")
    public suspend fun initTimeout(`value`: Output<String>) {
        this.initTimeout = value
    }

    /**
     * @param value Component metadata
     */
    @JvmName("joatpmlyfebfcwvk")
    public suspend fun metadata(`value`: Output<List<DaprMetadataArgs>>) {
        this.metadata = value
    }

    @JvmName("tlsyskdebyvxuxjn")
    public suspend fun metadata(vararg values: Output<DaprMetadataArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Component metadata
     */
    @JvmName("hwyktltrvxomyuja")
    public suspend fun metadata(values: List<Output<DaprMetadataArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ltiglsckyvxxdpyw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Names of container apps that can use this Dapr component
     */
    @JvmName("djbehcxudyeurtlk")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("qipmniopmfeqaijj")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Names of container apps that can use this Dapr component
     */
    @JvmName("fowwbnhpyejyvkjf")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Name of a Dapr component to retrieve component secrets from
     */
    @JvmName("eeutslrufagjoevr")
    public suspend fun secretStoreComponent(`value`: Output<String>) {
        this.secretStoreComponent = value
    }

    /**
     * @param value Collection of secrets used by a Dapr component
     */
    @JvmName("enqnmrrefobuyuqd")
    public suspend fun secrets(`value`: Output<List<SecretArgs>>) {
        this.secrets = value
    }

    @JvmName("wavkeurkhrmdgnlj")
    public suspend fun secrets(vararg values: Output<SecretArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Collection of secrets used by a Dapr component
     */
    @JvmName("itjvougbbhrijvdg")
    public suspend fun secrets(values: List<Output<SecretArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Component version
     */
    @JvmName("vkoxaknduyreckuw")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("fatpualgpnxthugi")
    public suspend fun componentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value Component type
     */
    @JvmName("obxmojypcbpvwrlh")
    public suspend fun componentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("whcendmjaavubtgn")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Boolean describing if the component errors are ignores
     */
    @JvmName("fstgpbtxanckydwm")
    public suspend fun ignoreErrors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreErrors = mapped
    }

    /**
     * @param value Initialization timeout
     */
    @JvmName("glbdupapnptkjvpn")
    public suspend fun initTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initTimeout = mapped
    }

    /**
     * @param value Component metadata
     */
    @JvmName("klbtpwcajtfdhwoh")
    public suspend fun metadata(`value`: List<DaprMetadataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Component metadata
     */
    @JvmName("aipadmvtrxogthau")
    public suspend fun metadata(argument: List<suspend DaprMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DaprMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Component metadata
     */
    @JvmName("bjplnxfkuwttbvyy")
    public suspend fun metadata(vararg argument: suspend DaprMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DaprMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Component metadata
     */
    @JvmName("logumxxklcikrtlx")
    public suspend fun metadata(argument: suspend DaprMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DaprMetadataArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Component metadata
     */
    @JvmName("asaiwsnwhjtaimrj")
    public suspend fun metadata(vararg values: DaprMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tlpycvrfvjeqtdxr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Names of container apps that can use this Dapr component
     */
    @JvmName("ckpicgyxcqrdqllh")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values Names of container apps that can use this Dapr component
     */
    @JvmName("vuinedjawvbighcj")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Name of a Dapr component to retrieve component secrets from
     */
    @JvmName("osdsuyjkeuhewwms")
    public suspend fun secretStoreComponent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreComponent = mapped
    }

    /**
     * @param value Collection of secrets used by a Dapr component
     */
    @JvmName("vgixorxmxjsnwduc")
    public suspend fun secrets(`value`: List<SecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Dapr component
     */
    @JvmName("qvujvwncoykctmld")
    public suspend fun secrets(argument: List<suspend SecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Dapr component
     */
    @JvmName("hsjserlcvgejmnju")
    public suspend fun secrets(vararg argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Dapr component
     */
    @JvmName("jkxjaysthlxoixae")
    public suspend fun secrets(argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Collection of secrets used by a Dapr component
     */
    @JvmName("oxioctibjkxvwiqf")
    public suspend fun secrets(vararg values: SecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Component version
     */
    @JvmName("oyqkxrijildnkqjq")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DaprComponentArgs = DaprComponentArgs(
        componentName = componentName,
        componentType = componentType,
        environmentName = environmentName,
        ignoreErrors = ignoreErrors,
        initTimeout = initTimeout,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        scopes = scopes,
        secretStoreComponent = secretStoreComponent,
        secrets = secrets,
        version = version,
    )
}
