@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.DaprSubscriptionArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.DaprSubscriptionBulkSubscribeOptionsArgs
import com.pulumi.azurenative.app.kotlin.inputs.DaprSubscriptionBulkSubscribeOptionsArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.DaprSubscriptionRoutesArgs
import com.pulumi.azurenative.app.kotlin.inputs.DaprSubscriptionRoutesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dapr PubSub Event Subscription.
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or update dapr subscription with bulk subscribe configuration and scopes
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprSubscription = new AzureNative.App.DaprSubscription("daprSubscription", new()
 *     {
 *         BulkSubscribe = new AzureNative.App.Inputs.DaprSubscriptionBulkSubscribeOptionsArgs
 *         {
 *             Enabled = true,
 *             MaxAwaitDurationMs = 500,
 *             MaxMessagesCount = 123,
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "mysubscription",
 *         PubsubName = "mypubsubcomponent",
 *         ResourceGroupName = "examplerg",
 *         Routes = new AzureNative.App.Inputs.DaprSubscriptionRoutesArgs
 *         {
 *             Default = "/products",
 *         },
 *         Scopes = new[]
 *         {
 *             "warehouseapp",
 *             "customersupportapp",
 *         },
 *         Topic = "inventory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprSubscription(ctx, "daprSubscription", &app.DaprSubscriptionArgs{
 * 			BulkSubscribe: &app.DaprSubscriptionBulkSubscribeOptionsArgs{
 * 				Enabled:            pulumi.Bool(true),
 * 				MaxAwaitDurationMs: pulumi.Int(500),
 * 				MaxMessagesCount:   pulumi.Int(123),
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mysubscription"),
 * 			PubsubName:        pulumi.String("mypubsubcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Routes: &app.DaprSubscriptionRoutesArgs{
 * 				Default: pulumi.String("/products"),
 * 			},
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("warehouseapp"),
 * 				pulumi.String("customersupportapp"),
 * 			},
 * 			Topic: pulumi.String("inventory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprSubscription;
 * import com.pulumi.azurenative.app.DaprSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprSubscription = new DaprSubscription("daprSubscription", DaprSubscriptionArgs.builder()
 *             .bulkSubscribe(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("maxAwaitDurationMs", 500),
 *                 Map.entry("maxMessagesCount", 123)
 *             ))
 *             .environmentName("myenvironment")
 *             .name("mysubscription")
 *             .pubsubName("mypubsubcomponent")
 *             .resourceGroupName("examplerg")
 *             .routes(Map.of("default", "/products"))
 *             .scopes(
 *                 "warehouseapp",
 *                 "customersupportapp")
 *             .topic("inventory")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr subscription with default route only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprSubscription = new AzureNative.App.DaprSubscription("daprSubscription", new()
 *     {
 *         EnvironmentName = "myenvironment",
 *         Name = "mysubscription",
 *         PubsubName = "mypubsubcomponent",
 *         ResourceGroupName = "examplerg",
 *         Routes = new AzureNative.App.Inputs.DaprSubscriptionRoutesArgs
 *         {
 *             Default = "/products",
 *         },
 *         Topic = "inventory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprSubscription(ctx, "daprSubscription", &app.DaprSubscriptionArgs{
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mysubscription"),
 * 			PubsubName:        pulumi.String("mypubsubcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Routes: &app.DaprSubscriptionRoutesArgs{
 * 				Default: pulumi.String("/products"),
 * 			},
 * 			Topic: pulumi.String("inventory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprSubscription;
 * import com.pulumi.azurenative.app.DaprSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprSubscription = new DaprSubscription("daprSubscription", DaprSubscriptionArgs.builder()
 *             .environmentName("myenvironment")
 *             .name("mysubscription")
 *             .pubsubName("mypubsubcomponent")
 *             .resourceGroupName("examplerg")
 *             .routes(Map.of("default", "/products"))
 *             .topic("inventory")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr subscription with route rules and metadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprSubscription = new AzureNative.App.DaprSubscription("daprSubscription", new()
 *     {
 *         EnvironmentName = "myenvironment",
 *         Metadata =
 *         {
 *             { "foo", "bar" },
 *             { "hello", "world" },
 *         },
 *         Name = "mysubscription",
 *         PubsubName = "mypubsubcomponent",
 *         ResourceGroupName = "examplerg",
 *         Routes = new AzureNative.App.Inputs.DaprSubscriptionRoutesArgs
 *         {
 *             Default = "/products",
 *             Rules = new[]
 *             {
 *                 new AzureNative.App.Inputs.DaprSubscriptionRouteRuleArgs
 *                 {
 *                     Match = "event.type == 'widget'",
 *                     Path = "/widgets",
 *                 },
 *                 new AzureNative.App.Inputs.DaprSubscriptionRouteRuleArgs
 *                 {
 *                     Match = "event.type == 'gadget'",
 *                     Path = "/gadgets",
 *                 },
 *             },
 *         },
 *         Topic = "inventory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprSubscription(ctx, "daprSubscription", &app.DaprSubscriptionArgs{
 * 			EnvironmentName: pulumi.String("myenvironment"),
 * 			Metadata: pulumi.StringMap{
 * 				"foo":   pulumi.String("bar"),
 * 				"hello": pulumi.String("world"),
 * 			},
 * 			Name:              pulumi.String("mysubscription"),
 * 			PubsubName:        pulumi.String("mypubsubcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Routes: app.DaprSubscriptionRoutesResponse{
 * 				Default: pulumi.String("/products"),
 * 				Rules: app.DaprSubscriptionRouteRuleArray{
 * 					&app.DaprSubscriptionRouteRuleArgs{
 * 						Match: pulumi.String("event.type == 'widget'"),
 * 						Path:  pulumi.String("/widgets"),
 * 					},
 * 					&app.DaprSubscriptionRouteRuleArgs{
 * 						Match: pulumi.String("event.type == 'gadget'"),
 * 						Path:  pulumi.String("/gadgets"),
 * 					},
 * 				},
 * 			},
 * 			Topic: pulumi.String("inventory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprSubscription;
 * import com.pulumi.azurenative.app.DaprSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprSubscription = new DaprSubscription("daprSubscription", DaprSubscriptionArgs.builder()
 *             .environmentName("myenvironment")
 *             .metadata(Map.ofEntries(
 *                 Map.entry("foo", "bar"),
 *                 Map.entry("hello", "world")
 *             ))
 *             .name("mysubscription")
 *             .pubsubName("mypubsubcomponent")
 *             .resourceGroupName("examplerg")
 *             .routes(Map.ofEntries(
 *                 Map.entry("default", "/products"),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("match", "event.type == 'widget'"),
 *                         Map.entry("path", "/widgets")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("match", "event.type == 'gadget'"),
 *                         Map.entry("path", "/gadgets")
 *                     ))
 *             ))
 *             .topic("inventory")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DaprSubscription mysubscription /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/daprSubscriptions/{name}
 * ```
 * @property bulkSubscribe Bulk subscription options
 * @property deadLetterTopic Deadletter topic name
 * @property environmentName Name of the Managed Environment.
 * @property metadata Subscription metadata
 * @property name Name of the Dapr subscription.
 * @property pubsubName Dapr PubSub component name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routes Subscription routes
 * @property scopes Application scopes to restrict the subscription to specific apps.
 * @property topic Topic name
 */
public data class DaprSubscriptionArgs(
    public val bulkSubscribe: Output<DaprSubscriptionBulkSubscribeOptionsArgs>? = null,
    public val deadLetterTopic: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val pubsubName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routes: Output<DaprSubscriptionRoutesArgs>? = null,
    public val scopes: Output<List<String>>? = null,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.DaprSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.app.DaprSubscriptionArgs =
        com.pulumi.azurenative.app.DaprSubscriptionArgs.builder()
            .bulkSubscribe(bulkSubscribe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deadLetterTopic(deadLetterTopic?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .pubsubName(pubsubName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprSubscriptionArgs].
 */
@PulumiTagMarker
public class DaprSubscriptionArgsBuilder internal constructor() {
    private var bulkSubscribe: Output<DaprSubscriptionBulkSubscribeOptionsArgs>? = null

    private var deadLetterTopic: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var pubsubName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routes: Output<DaprSubscriptionRoutesArgs>? = null

    private var scopes: Output<List<String>>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Bulk subscription options
     */
    @JvmName("ucyrdrpvvuxfkaid")
    public suspend fun bulkSubscribe(`value`: Output<DaprSubscriptionBulkSubscribeOptionsArgs>) {
        this.bulkSubscribe = value
    }

    /**
     * @param value Deadletter topic name
     */
    @JvmName("tqavreklyppmdklw")
    public suspend fun deadLetterTopic(`value`: Output<String>) {
        this.deadLetterTopic = value
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("rfblskitpxikeoiy")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Subscription metadata
     */
    @JvmName("ftlrjmfwdomojoon")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value Name of the Dapr subscription.
     */
    @JvmName("wqydnrliultfnckl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Dapr PubSub component name
     */
    @JvmName("jcxwifyarwiepoab")
    public suspend fun pubsubName(`value`: Output<String>) {
        this.pubsubName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fisbfvbfqhvebuek")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Subscription routes
     */
    @JvmName("vnvnadsuclckyrei")
    public suspend fun routes(`value`: Output<DaprSubscriptionRoutesArgs>) {
        this.routes = value
    }

    /**
     * @param value Application scopes to restrict the subscription to specific apps.
     */
    @JvmName("cipoaipklsbshlqs")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("owfdgvmswurgvyhg")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Application scopes to restrict the subscription to specific apps.
     */
    @JvmName("amjeconhmnaobknh")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Topic name
     */
    @JvmName("rfjjewscjmbobaxy")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Bulk subscription options
     */
    @JvmName("niwopgmwerlfaxsk")
    public suspend fun bulkSubscribe(`value`: DaprSubscriptionBulkSubscribeOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bulkSubscribe = mapped
    }

    /**
     * @param argument Bulk subscription options
     */
    @JvmName("crowbxoohrkwhuof")
    public suspend
    fun bulkSubscribe(argument: suspend DaprSubscriptionBulkSubscribeOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DaprSubscriptionBulkSubscribeOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.bulkSubscribe = mapped
    }

    /**
     * @param value Deadletter topic name
     */
    @JvmName("kkyfighppdjbktsv")
    public suspend fun deadLetterTopic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterTopic = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("roporxlrddckbafv")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Subscription metadata
     */
    @JvmName("fddourmfqdkayxwq")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Subscription metadata
     */
    @JvmName("uynvfmgxxpccqwct")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Name of the Dapr subscription.
     */
    @JvmName("ppkdjlcywawuykif")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Dapr PubSub component name
     */
    @JvmName("oaaejohivpfeteib")
    public suspend fun pubsubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pubsubName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ixftiqeueipsnjmj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription routes
     */
    @JvmName("jmtldnfcypamvjlu")
    public suspend fun routes(`value`: DaprSubscriptionRoutesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Subscription routes
     */
    @JvmName("qacsiknslxvtahhx")
    public suspend fun routes(argument: suspend DaprSubscriptionRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = DaprSubscriptionRoutesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param value Application scopes to restrict the subscription to specific apps.
     */
    @JvmName("jhlnfsxnbuekfbvc")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values Application scopes to restrict the subscription to specific apps.
     */
    @JvmName("saamiohvblvnvccc")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Topic name
     */
    @JvmName("jxqibnojcjpsxlkq")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): DaprSubscriptionArgs = DaprSubscriptionArgs(
        bulkSubscribe = bulkSubscribe,
        deadLetterTopic = deadLetterTopic,
        environmentName = environmentName,
        metadata = metadata,
        name = name,
        pubsubName = pubsubName,
        resourceGroupName = resourceGroupName,
        routes = routes,
        scopes = scopes,
        topic = topic,
    )
}
