@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.DotNetComponentConfigurationPropertyResponse
import com.pulumi.azurenative.app.kotlin.outputs.DotNetComponentServiceBindResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.app.kotlin.outputs.DotNetComponentConfigurationPropertyResponse.Companion.toKotlin as dotNetComponentConfigurationPropertyResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.DotNetComponentServiceBindResponse.Companion.toKotlin as dotNetComponentServiceBindResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DotNetComponent].
 */
@PulumiTagMarker
public class DotNetComponentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DotNetComponentArgs = DotNetComponentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DotNetComponentArgsBuilder.() -> Unit) {
        val builder = DotNetComponentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DotNetComponent {
        val builtJavaResource = com.pulumi.azurenative.app.DotNetComponent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DotNetComponent(builtJavaResource)
    }
}

/**
 * .NET Component.
 * Azure REST API version: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update .NET Component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dotNetComponent = new AzureNative.App.DotNetComponent("dotNetComponent", new()
 *     {
 *         ComponentType = "AspireDashboard",
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.DotNetComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "dashboard-theme",
 *                 Value = "dark",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "mydotnetcomponent",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDotNetComponent(ctx, "dotNetComponent", &app.DotNetComponentArgs{
 * 			ComponentType: pulumi.String("AspireDashboard"),
 * 			Configurations: []app.DotNetComponentConfigurationPropertyArgs{
 * 				{
 * 					PropertyName: pulumi.String("dashboard-theme"),
 * 					Value:        pulumi.String("dark"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mydotnetcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DotNetComponent;
 * import com.pulumi.azurenative.app.DotNetComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dotNetComponent = new DotNetComponent("dotNetComponent", DotNetComponentArgs.builder()
 *             .componentType("AspireDashboard")
 *             .configurations(Map.ofEntries(
 *                 Map.entry("propertyName", "dashboard-theme"),
 *                 Map.entry("value", "dark")
 *             ))
 *             .environmentName("myenvironment")
 *             .name("mydotnetcomponent")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update .NET Component with ServiceBinds
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dotNetComponent = new AzureNative.App.DotNetComponent("dotNetComponent", new()
 *     {
 *         ComponentType = "AspireDashboard",
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.DotNetComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "dashboard-theme",
 *                 Value = "dark",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "mydotnetcomponent",
 *         ResourceGroupName = "examplerg",
 *         ServiceBinds = new[]
 *         {
 *             new AzureNative.App.Inputs.DotNetComponentServiceBindArgs
 *             {
 *                 Name = "yellowcat",
 *                 ServiceId = "/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/dotNetComponents/yellowcat",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDotNetComponent(ctx, "dotNetComponent", &app.DotNetComponentArgs{
 * 			ComponentType: pulumi.String("AspireDashboard"),
 * 			Configurations: []app.DotNetComponentConfigurationPropertyArgs{
 * 				{
 * 					PropertyName: pulumi.String("dashboard-theme"),
 * 					Value:        pulumi.String("dark"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mydotnetcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			ServiceBinds: []app.DotNetComponentServiceBindArgs{
 * 				{
 * 					Name:      pulumi.String("yellowcat"),
 * 					ServiceId: pulumi.String("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/dotNetComponents/yellowcat"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DotNetComponent;
 * import com.pulumi.azurenative.app.DotNetComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dotNetComponent = new DotNetComponent("dotNetComponent", DotNetComponentArgs.builder()
 *             .componentType("AspireDashboard")
 *             .configurations(Map.ofEntries(
 *                 Map.entry("propertyName", "dashboard-theme"),
 *                 Map.entry("value", "dark")
 *             ))
 *             .environmentName("myenvironment")
 *             .name("mydotnetcomponent")
 *             .resourceGroupName("examplerg")
 *             .serviceBinds(Map.ofEntries(
 *                 Map.entry("name", "yellowcat"),
 *                 Map.entry("serviceId", "/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/dotNetComponents/yellowcat")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DotNetComponent mydotnetcomponent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/dotNetComponents/{name}
 * ```
 */
public class DotNetComponent internal constructor(
    override val javaResource: com.pulumi.azurenative.app.DotNetComponent,
) : KotlinCustomResource(javaResource, DotNetComponentMapper) {
    /**
     * Type of the .NET Component.
     */
    public val componentType: Output<String>?
        get() = javaResource.componentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of .NET Components configuration properties
     */
    public val configurations: Output<List<DotNetComponentConfigurationPropertyResponse>>?
        get() = javaResource.configurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dotNetComponentConfigurationPropertyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the .NET Component.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of .NET Components that are bound to the .NET component
     */
    public val serviceBinds: Output<List<DotNetComponentServiceBindResponse>>?
        get() = javaResource.serviceBinds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dotNetComponentServiceBindResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DotNetComponentMapper : ResourceMapper<DotNetComponent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.DotNetComponent::class == javaResource::class

    override fun map(javaResource: Resource): DotNetComponent = DotNetComponent(
        javaResource as
            com.pulumi.azurenative.app.DotNetComponent,
    )
}

/**
 * @see [DotNetComponent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DotNetComponent].
 */
public suspend fun dotNetComponent(
    name: String,
    block: suspend DotNetComponentResourceBuilder.() -> Unit,
): DotNetComponent {
    val builder = DotNetComponentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DotNetComponent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dotNetComponent(name: String): DotNetComponent {
    val builder = DotNetComponentResourceBuilder()
    builder.name(name)
    return builder.build()
}
