@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.JavaComponentConfigurationPropertyResponse
import com.pulumi.azurenative.app.kotlin.outputs.JavaComponentServiceBindResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.app.kotlin.outputs.JavaComponentConfigurationPropertyResponse.Companion.toKotlin as javaComponentConfigurationPropertyResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.JavaComponentServiceBindResponse.Companion.toKotlin as javaComponentServiceBindResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [JavaComponent].
 */
@PulumiTagMarker
public class JavaComponentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JavaComponentArgs = JavaComponentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JavaComponentArgsBuilder.() -> Unit) {
        val builder = JavaComponentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JavaComponent {
        val builtJavaResource = com.pulumi.azurenative.app.JavaComponent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JavaComponent(builtJavaResource)
    }
}

/**
 * Java Component.
 * Azure REST API version: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update Java Component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var javaComponent = new AzureNative.App.JavaComponent("javaComponent", new()
 *     {
 *         ComponentType = "SpringBootAdmin",
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.ui.enable-toasts",
 *                 Value = "true",
 *             },
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.monitor.status-interval",
 *                 Value = "10000ms",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "myjavacomponent",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewJavaComponent(ctx, "javaComponent", &app.JavaComponentArgs{
 * 			ComponentType: pulumi.String("SpringBootAdmin"),
 * 			Configurations: []app.JavaComponentConfigurationPropertyArgs{
 * 				{
 * 					PropertyName: pulumi.String("spring.boot.admin.ui.enable-toasts"),
 * 					Value:        pulumi.String("true"),
 * 				},
 * 				{
 * 					PropertyName: pulumi.String("spring.boot.admin.monitor.status-interval"),
 * 					Value:        pulumi.String("10000ms"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("myjavacomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.JavaComponent;
 * import com.pulumi.azurenative.app.JavaComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var javaComponent = new JavaComponent("javaComponent", JavaComponentArgs.builder()
 *             .componentType("SpringBootAdmin")
 *             .configurations(
 *                 Map.ofEntries(
 *                     Map.entry("propertyName", "spring.boot.admin.ui.enable-toasts"),
 *                     Map.entry("value", "true")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("propertyName", "spring.boot.admin.monitor.status-interval"),
 *                     Map.entry("value", "10000ms")
 *                 ))
 *             .environmentName("myenvironment")
 *             .name("myjavacomponent")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Java Component with ServiceBinds
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var javaComponent = new AzureNative.App.JavaComponent("javaComponent", new()
 *     {
 *         ComponentType = "SpringBootAdmin",
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.ui.enable-toasts",
 *                 Value = "true",
 *             },
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.monitor.status-interval",
 *                 Value = "10000ms",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "myjavacomponent",
 *         ResourceGroupName = "examplerg",
 *         ServiceBinds = new[]
 *         {
 *             new AzureNative.App.Inputs.JavaComponentServiceBindArgs
 *             {
 *                 Name = "yellowcat",
 *                 ServiceId = "/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/javaComponents/yellowcat",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewJavaComponent(ctx, "javaComponent", &app.JavaComponentArgs{
 * 			ComponentType: pulumi.String("SpringBootAdmin"),
 * 			Configurations: []app.JavaComponentConfigurationPropertyArgs{
 * 				{
 * 					PropertyName: pulumi.String("spring.boot.admin.ui.enable-toasts"),
 * 					Value:        pulumi.String("true"),
 * 				},
 * 				{
 * 					PropertyName: pulumi.String("spring.boot.admin.monitor.status-interval"),
 * 					Value:        pulumi.String("10000ms"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("myjavacomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			ServiceBinds: []app.JavaComponentServiceBindArgs{
 * 				{
 * 					Name:      pulumi.String("yellowcat"),
 * 					ServiceId: pulumi.String("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/javaComponents/yellowcat"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.JavaComponent;
 * import com.pulumi.azurenative.app.JavaComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var javaComponent = new JavaComponent("javaComponent", JavaComponentArgs.builder()
 *             .componentType("SpringBootAdmin")
 *             .configurations(
 *                 Map.ofEntries(
 *                     Map.entry("propertyName", "spring.boot.admin.ui.enable-toasts"),
 *                     Map.entry("value", "true")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("propertyName", "spring.boot.admin.monitor.status-interval"),
 *                     Map.entry("value", "10000ms")
 *                 ))
 *             .environmentName("myenvironment")
 *             .name("myjavacomponent")
 *             .resourceGroupName("examplerg")
 *             .serviceBinds(Map.ofEntries(
 *                 Map.entry("name", "yellowcat"),
 *                 Map.entry("serviceId", "/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/javaComponents/yellowcat")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:JavaComponent myjavacomponent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/javaComponents/{name}
 * ```
 */
public class JavaComponent internal constructor(
    override val javaResource: com.pulumi.azurenative.app.JavaComponent,
) : KotlinCustomResource(javaResource, JavaComponentMapper) {
    /**
     * Type of the Java Component.
     */
    public val componentType: Output<String>?
        get() = javaResource.componentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of Java Components configuration properties
     */
    public val configurations: Output<List<JavaComponentConfigurationPropertyResponse>>?
        get() = javaResource.configurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        javaComponentConfigurationPropertyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Java Component.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of Java Components that are bound to the Java component
     */
    public val serviceBinds: Output<List<JavaComponentServiceBindResponse>>?
        get() = javaResource.serviceBinds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> javaComponentServiceBindResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JavaComponentMapper : ResourceMapper<JavaComponent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.JavaComponent::class == javaResource::class

    override fun map(javaResource: Resource): JavaComponent = JavaComponent(
        javaResource as
            com.pulumi.azurenative.app.JavaComponent,
    )
}

/**
 * @see [JavaComponent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JavaComponent].
 */
public suspend fun javaComponent(
    name: String,
    block: suspend JavaComponentResourceBuilder.() -> Unit,
): JavaComponent {
    val builder = JavaComponentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JavaComponent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun javaComponent(name: String): JavaComponent {
    val builder = JavaComponentResourceBuilder()
    builder.name(name)
    return builder.build()
}
