@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ManagedEnvironmentArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.AppLogsConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.AppLogsConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.CustomDomainConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.CustomDomainConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.EnvironmentSkuPropertiesArgs
import com.pulumi.azurenative.app.kotlin.inputs.EnvironmentSkuPropertiesArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.VnetConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.VnetConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.WorkloadProfileArgs
import com.pulumi.azurenative.app.kotlin.inputs.WorkloadProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An environment for hosting container apps
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create environments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedEnvironment = new AzureNative.App.ManagedEnvironment("managedEnvironment", new()
 *     {
 *         AppLogsConfiguration = new AzureNative.App.Inputs.AppLogsConfigurationArgs
 *         {
 *             LogAnalyticsConfiguration = new AzureNative.App.Inputs.LogAnalyticsConfigurationArgs
 *             {
 *                 CustomerId = "string",
 *                 SharedKey = "string",
 *             },
 *         },
 *         CustomDomainConfiguration = new AzureNative.App.Inputs.CustomDomainConfigurationArgs
 *         {
 *             CertificatePassword = "private key password",
 *             CertificateValue = "Y2VydA==",
 *             DnsSuffix = "www.my-name.com",
 *         },
 *         DaprAIConnectionString = "InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/",
 *         EnvironmentName = "testcontainerenv",
 *         Kind = "serverless",
 *         Location = "East US",
 *         ResourceGroupName = "examplerg",
 *         Sku = new AzureNative.App.Inputs.EnvironmentSkuPropertiesArgs
 *         {
 *             Name = "Premium",
 *         },
 *         VnetConfiguration = new AzureNative.App.Inputs.VnetConfigurationArgs
 *         {
 *             OutboundSettings = new AzureNative.App.Inputs.ManagedEnvironmentOutboundSettingsArgs
 *             {
 *                 OutBoundType = "UserDefinedRouting",
 *                 VirtualNetworkApplianceIp = "192.168.1.20",
 *             },
 *         },
 *         WorkloadProfiles = new[]
 *         {
 *             new AzureNative.App.Inputs.WorkloadProfileArgs
 *             {
 *                 MaximumCount = 12,
 *                 MinimumCount = 3,
 *                 WorkloadProfileType = "GeneralPurpose",
 *             },
 *             new AzureNative.App.Inputs.WorkloadProfileArgs
 *             {
 *                 MaximumCount = 6,
 *                 MinimumCount = 3,
 *                 WorkloadProfileType = "MemoryOptimized",
 *             },
 *             new AzureNative.App.Inputs.WorkloadProfileArgs
 *             {
 *                 MaximumCount = 6,
 *                 MinimumCount = 3,
 *                 WorkloadProfileType = "ComputeOptimized",
 *             },
 *         },
 *         ZoneRedundant = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewManagedEnvironment(ctx, "managedEnvironment", &app.ManagedEnvironmentArgs{
 * 			AppLogsConfiguration: app.AppLogsConfigurationResponse{
 * 				LogAnalyticsConfiguration: &app.LogAnalyticsConfigurationArgs{
 * 					CustomerId: pulumi.String("string"),
 * 					SharedKey:  pulumi.String("string"),
 * 				},
 * 			},
 * 			CustomDomainConfiguration: &app.CustomDomainConfigurationArgs{
 * 				CertificatePassword: pulumi.String("private key password"),
 * 				CertificateValue:    pulumi.String("Y2VydA=="),
 * 				DnsSuffix:           pulumi.String("www.my-name.com"),
 * 			},
 * 			DaprAIConnectionString: pulumi.String("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/"),
 * 			EnvironmentName:        pulumi.String("testcontainerenv"),
 * 			Kind:                   pulumi.String("serverless"),
 * 			Location:               pulumi.String("East US"),
 * 			ResourceGroupName:      pulumi.String("examplerg"),
 * 			Sku: &app.EnvironmentSkuPropertiesArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 			VnetConfiguration: app.VnetConfigurationResponse{
 * 				OutboundSettings: &app.ManagedEnvironmentOutboundSettingsArgs{
 * 					OutBoundType:              pulumi.String("UserDefinedRouting"),
 * 					VirtualNetworkApplianceIp: pulumi.String("192.168.1.20"),
 * 				},
 * 			},
 * 			WorkloadProfiles: []app.WorkloadProfileArgs{
 * 				{
 * 					MaximumCount:        pulumi.Int(12),
 * 					MinimumCount:        pulumi.Int(3),
 * 					WorkloadProfileType: pulumi.String("GeneralPurpose"),
 * 				},
 * 				{
 * 					MaximumCount:        pulumi.Int(6),
 * 					MinimumCount:        pulumi.Int(3),
 * 					WorkloadProfileType: pulumi.String("MemoryOptimized"),
 * 				},
 * 				{
 * 					MaximumCount:        pulumi.Int(6),
 * 					MinimumCount:        pulumi.Int(3),
 * 					WorkloadProfileType: pulumi.String("ComputeOptimized"),
 * 				},
 * 			},
 * 			ZoneRedundant: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ManagedEnvironment;
 * import com.pulumi.azurenative.app.ManagedEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedEnvironment = new ManagedEnvironment("managedEnvironment", ManagedEnvironmentArgs.builder()
 *             .appLogsConfiguration(Map.of("logAnalyticsConfiguration", Map.ofEntries(
 *                 Map.entry("customerId", "string"),
 *                 Map.entry("sharedKey", "string")
 *             )))
 *             .customDomainConfiguration(Map.ofEntries(
 *                 Map.entry("certificatePassword", "private key password"),
 *                 Map.entry("certificateValue", "Y2VydA=="),
 *                 Map.entry("dnsSuffix", "www.my-name.com")
 *             ))
 *             .daprAIConnectionString("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/")
 *             .environmentName("testcontainerenv")
 *             .kind("serverless")
 *             .location("East US")
 *             .resourceGroupName("examplerg")
 *             .sku(Map.of("name", "Premium"))
 *             .vnetConfiguration(Map.of("outboundSettings", Map.ofEntries(
 *                 Map.entry("outBoundType", "UserDefinedRouting"),
 *                 Map.entry("virtualNetworkApplianceIp", "192.168.1.20")
 *             )))
 *             .workloadProfiles(
 *                 Map.ofEntries(
 *                     Map.entry("maximumCount", 12),
 *                     Map.entry("minimumCount", 3),
 *                     Map.entry("workloadProfileType", "GeneralPurpose")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("maximumCount", 6),
 *                     Map.entry("minimumCount", 3),
 *                     Map.entry("workloadProfileType", "MemoryOptimized")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("maximumCount", 6),
 *                     Map.entry("minimumCount", 3),
 *                     Map.entry("workloadProfileType", "ComputeOptimized")
 *                 ))
 *             .zoneRedundant(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ManagedEnvironment testcontainerenv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}
 * ```
 * @property appLogsConfiguration Cluster configuration which enables the log daemon to export
 * app logs to a destination. Currently only "log-analytics" is
 * supported
 * @property customDomainConfiguration Custom domain configuration for the environment
 * @property daprAIConnectionString Application Insights connection string used by Dapr to export Service to Service communication telemetry
 * @property daprAIInstrumentationKey Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
 * @property environmentName Name of the Environment.
 * @property kind Kind of the Environment.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku SKU properties of the Environment.
 * @property tags Resource tags.
 * @property vnetConfiguration Vnet configuration for the environment
 * @property workloadProfiles Workload profiles configured for the Managed Environment.
 * @property zoneRedundant Whether or not this Managed Environment is zone-redundant.
 */
public data class ManagedEnvironmentArgs(
    public val appLogsConfiguration: Output<AppLogsConfigurationArgs>? = null,
    public val customDomainConfiguration: Output<CustomDomainConfigurationArgs>? = null,
    public val daprAIConnectionString: Output<String>? = null,
    public val daprAIInstrumentationKey: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<EnvironmentSkuPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vnetConfiguration: Output<VnetConfigurationArgs>? = null,
    public val workloadProfiles: Output<List<WorkloadProfileArgs>>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ManagedEnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ManagedEnvironmentArgs =
        com.pulumi.azurenative.app.ManagedEnvironmentArgs.builder()
            .appLogsConfiguration(
                appLogsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customDomainConfiguration(
                customDomainConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .daprAIConnectionString(daprAIConnectionString?.applyValue({ args0 -> args0 }))
            .daprAIInstrumentationKey(daprAIInstrumentationKey?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vnetConfiguration(vnetConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadProfiles(
                workloadProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedEnvironmentArgs].
 */
@PulumiTagMarker
public class ManagedEnvironmentArgsBuilder internal constructor() {
    private var appLogsConfiguration: Output<AppLogsConfigurationArgs>? = null

    private var customDomainConfiguration: Output<CustomDomainConfigurationArgs>? = null

    private var daprAIConnectionString: Output<String>? = null

    private var daprAIInstrumentationKey: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<EnvironmentSkuPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vnetConfiguration: Output<VnetConfigurationArgs>? = null

    private var workloadProfiles: Output<List<WorkloadProfileArgs>>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    @JvmName("yoyctsmlbjlkxlus")
    public suspend fun appLogsConfiguration(`value`: Output<AppLogsConfigurationArgs>) {
        this.appLogsConfiguration = value
    }

    /**
     * @param value Custom domain configuration for the environment
     */
    @JvmName("dfjpaggxcvbiwmqr")
    public suspend fun customDomainConfiguration(`value`: Output<CustomDomainConfigurationArgs>) {
        this.customDomainConfiguration = value
    }

    /**
     * @param value Application Insights connection string used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("ckwuhbogapnyymrc")
    public suspend fun daprAIConnectionString(`value`: Output<String>) {
        this.daprAIConnectionString = value
    }

    /**
     * @param value Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("ubsywayshwfngoal")
    public suspend fun daprAIInstrumentationKey(`value`: Output<String>) {
        this.daprAIInstrumentationKey = value
    }

    /**
     * @param value Name of the Environment.
     */
    @JvmName("uywxixetjjpscype")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Kind of the Environment.
     */
    @JvmName("cnkufbejhxksooit")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lmsqavbcokrrlyug")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wbjoccdhdtfjpppq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU properties of the Environment.
     */
    @JvmName("jxysmgurkwaxedwx")
    public suspend fun sku(`value`: Output<EnvironmentSkuPropertiesArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sprihouryfuhuyqe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Vnet configuration for the environment
     */
    @JvmName("omjjsbtcksmkmwmv")
    public suspend fun vnetConfiguration(`value`: Output<VnetConfigurationArgs>) {
        this.vnetConfiguration = value
    }

    /**
     * @param value Workload profiles configured for the Managed Environment.
     */
    @JvmName("ieyubpybtejkjttf")
    public suspend fun workloadProfiles(`value`: Output<List<WorkloadProfileArgs>>) {
        this.workloadProfiles = value
    }

    @JvmName("ryrjiymgbmdkalxi")
    public suspend fun workloadProfiles(vararg values: Output<WorkloadProfileArgs>) {
        this.workloadProfiles = Output.all(values.asList())
    }

    /**
     * @param values Workload profiles configured for the Managed Environment.
     */
    @JvmName("xgdimqvqnfypxewn")
    public suspend fun workloadProfiles(values: List<Output<WorkloadProfileArgs>>) {
        this.workloadProfiles = Output.all(values)
    }

    /**
     * @param value Whether or not this Managed Environment is zone-redundant.
     */
    @JvmName("ulxvqgfsnkbwryyt")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    @JvmName("dsdqoclgvfvywxes")
    public suspend fun appLogsConfiguration(`value`: AppLogsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appLogsConfiguration = mapped
    }

    /**
     * @param argument Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    @JvmName("yolnvrdiyldmlarb")
    public suspend
    fun appLogsConfiguration(argument: suspend AppLogsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AppLogsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.appLogsConfiguration = mapped
    }

    /**
     * @param value Custom domain configuration for the environment
     */
    @JvmName("pmifdvgiwjrfvcgo")
    public suspend fun customDomainConfiguration(`value`: CustomDomainConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomainConfiguration = mapped
    }

    /**
     * @param argument Custom domain configuration for the environment
     */
    @JvmName("serpscjkinpwrtcm")
    public suspend
    fun customDomainConfiguration(argument: suspend CustomDomainConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomDomainConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDomainConfiguration = mapped
    }

    /**
     * @param value Application Insights connection string used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("gcexiccyjsvcqymk")
    public suspend fun daprAIConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daprAIConnectionString = mapped
    }

    /**
     * @param value Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("nehsylhmpircmyfa")
    public suspend fun daprAIInstrumentationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daprAIInstrumentationKey = mapped
    }

    /**
     * @param value Name of the Environment.
     */
    @JvmName("mslouvkqaorvsupc")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Kind of the Environment.
     */
    @JvmName("yykvjhhbhoedlxrr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ayrstaergxvjcrrr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rnxqstnksryyyiof")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU properties of the Environment.
     */
    @JvmName("gfjbodjwwnpjndik")
    public suspend fun sku(`value`: EnvironmentSkuPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU properties of the Environment.
     */
    @JvmName("wsquerrmgelpcxqy")
    public suspend fun sku(argument: suspend EnvironmentSkuPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentSkuPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nctvmwuobsjntoky")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tomaienywevxeiux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Vnet configuration for the environment
     */
    @JvmName("sydselauiudvodrq")
    public suspend fun vnetConfiguration(`value`: VnetConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetConfiguration = mapped
    }

    /**
     * @param argument Vnet configuration for the environment
     */
    @JvmName("nafnubneppcsfeur")
    public suspend fun vnetConfiguration(argument: suspend VnetConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VnetConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetConfiguration = mapped
    }

    /**
     * @param value Workload profiles configured for the Managed Environment.
     */
    @JvmName("wqsxtuxhmwmyyrbq")
    public suspend fun workloadProfiles(`value`: List<WorkloadProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadProfiles = mapped
    }

    /**
     * @param argument Workload profiles configured for the Managed Environment.
     */
    @JvmName("yvmfyatkmaskdqvs")
    public suspend
    fun workloadProfiles(argument: List<suspend WorkloadProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkloadProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workloadProfiles = mapped
    }

    /**
     * @param argument Workload profiles configured for the Managed Environment.
     */
    @JvmName("rkygeeviwpheexpb")
    public suspend fun workloadProfiles(
        vararg
        argument: suspend WorkloadProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkloadProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workloadProfiles = mapped
    }

    /**
     * @param argument Workload profiles configured for the Managed Environment.
     */
    @JvmName("hwyewdtoopylgaof")
    public suspend fun workloadProfiles(argument: suspend WorkloadProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WorkloadProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.workloadProfiles = mapped
    }

    /**
     * @param values Workload profiles configured for the Managed Environment.
     */
    @JvmName("clqllqqlrakfvehs")
    public suspend fun workloadProfiles(vararg values: WorkloadProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadProfiles = mapped
    }

    /**
     * @param value Whether or not this Managed Environment is zone-redundant.
     */
    @JvmName("normupivxjvghsxp")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): ManagedEnvironmentArgs = ManagedEnvironmentArgs(
        appLogsConfiguration = appLogsConfiguration,
        customDomainConfiguration = customDomainConfiguration,
        daprAIConnectionString = daprAIConnectionString,
        daprAIInstrumentationKey = daprAIInstrumentationKey,
        environmentName = environmentName,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        vnetConfiguration = vnetConfiguration,
        workloadProfiles = workloadProfiles,
        zoneRedundant = zoneRedundant,
    )
}
