@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the .NET Component.
 */
public enum class DotNetComponentType(
    public val javaValue: com.pulumi.azurenative.app.enums.DotNetComponentType,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.DotNetComponentType> {
    AspireDashboard(com.pulumi.azurenative.app.enums.DotNetComponentType.AspireDashboard),
    AspireResourceServerApi(com.pulumi.azurenative.app.enums.DotNetComponentType.AspireResourceServerApi),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.DotNetComponentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.DotNetComponentType):
            DotNetComponentType = DotNetComponentType.values().first { it.javaValue == javaType }
    }
}
