@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the Java Component.
 */
public enum class JavaComponentType(
    public val javaValue: com.pulumi.azurenative.app.enums.JavaComponentType,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.JavaComponentType> {
    SpringBootAdmin(com.pulumi.azurenative.app.enums.JavaComponentType.SpringBootAdmin),
    SpringCloudEureka(com.pulumi.azurenative.app.enums.JavaComponentType.SpringCloudEureka),
    SpringCloudConfig(com.pulumi.azurenative.app.enums.JavaComponentType.SpringCloudConfig),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.JavaComponentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.JavaComponentType):
            JavaComponentType = JavaComponentType.values().first { it.javaValue == javaType }
    }
}
