@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Storage type for the volume. If not provided, use EmptyDir.
 */
public enum class StorageType(
    public val javaValue: com.pulumi.azurenative.app.enums.StorageType,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.StorageType> {
    AzureFile(com.pulumi.azurenative.app.enums.StorageType.AzureFile),
    EmptyDir(com.pulumi.azurenative.app.enums.StorageType.EmptyDir),
    Secret(com.pulumi.azurenative.app.enums.StorageType.Secret),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.StorageType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.StorageType): StorageType =
            StorageType.values().first { it.javaValue == javaType }
    }
}
