@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AppLogsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration of application logs
 * @property destination Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'
 * @property logAnalyticsConfiguration Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
 */
public data class AppLogsConfigurationArgs(
    public val destination: Output<String>? = null,
    public val logAnalyticsConfiguration: Output<LogAnalyticsConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AppLogsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AppLogsConfigurationArgs =
        com.pulumi.azurenative.app.inputs.AppLogsConfigurationArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .logAnalyticsConfiguration(
                logAnalyticsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AppLogsConfigurationArgs].
 */
@PulumiTagMarker
public class AppLogsConfigurationArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var logAnalyticsConfiguration: Output<LogAnalyticsConfigurationArgs>? = null

    /**
     * @param value Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'
     */
    @JvmName("aflijgrmyeyqjcym")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
     */
    @JvmName("wouexwvdsdgtjyoi")
    public suspend fun logAnalyticsConfiguration(`value`: Output<LogAnalyticsConfigurationArgs>) {
        this.logAnalyticsConfiguration = value
    }

    /**
     * @param value Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'
     */
    @JvmName("hocbkyulxspclptj")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
     */
    @JvmName("fxilqfaqkwnlfbca")
    public suspend fun logAnalyticsConfiguration(`value`: LogAnalyticsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsConfiguration = mapped
    }

    /**
     * @param argument Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
     */
    @JvmName("vqrfkooylhummbda")
    public suspend
    fun logAnalyticsConfiguration(argument: suspend LogAnalyticsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LogAnalyticsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logAnalyticsConfiguration = mapped
    }

    internal fun build(): AppLogsConfigurationArgs = AppLogsConfigurationArgs(
        destination = destination,
        logAnalyticsConfiguration = logAnalyticsConfiguration,
    )
}
