@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CircuitBreakerPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy that defines circuit breaker conditions
 * @property consecutiveErrors Number of consecutive errors before the circuit breaker opens
 * @property intervalInSeconds The time interval, in seconds, between endpoint checks. This can result in opening the circuit breaker if the check fails as well as closing the circuit breaker if the check succeeds. Defaults to 10s.
 * @property maxEjectionPercent Maximum percentage of hosts that will be ejected after failure threshold has been met
 */
public data class CircuitBreakerPolicyArgs(
    public val consecutiveErrors: Output<Int>? = null,
    public val intervalInSeconds: Output<Int>? = null,
    public val maxEjectionPercent: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CircuitBreakerPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CircuitBreakerPolicyArgs =
        com.pulumi.azurenative.app.inputs.CircuitBreakerPolicyArgs.builder()
            .consecutiveErrors(consecutiveErrors?.applyValue({ args0 -> args0 }))
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 }))
            .maxEjectionPercent(maxEjectionPercent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CircuitBreakerPolicyArgs].
 */
@PulumiTagMarker
public class CircuitBreakerPolicyArgsBuilder internal constructor() {
    private var consecutiveErrors: Output<Int>? = null

    private var intervalInSeconds: Output<Int>? = null

    private var maxEjectionPercent: Output<Int>? = null

    /**
     * @param value Number of consecutive errors before the circuit breaker opens
     */
    @JvmName("vkceyqssrlxftfdf")
    public suspend fun consecutiveErrors(`value`: Output<Int>) {
        this.consecutiveErrors = value
    }

    /**
     * @param value The time interval, in seconds, between endpoint checks. This can result in opening the circuit breaker if the check fails as well as closing the circuit breaker if the check succeeds. Defaults to 10s.
     */
    @JvmName("bmafxfilibvpvuuq")
    public suspend fun intervalInSeconds(`value`: Output<Int>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value Maximum percentage of hosts that will be ejected after failure threshold has been met
     */
    @JvmName("nxyheofcunwsawqn")
    public suspend fun maxEjectionPercent(`value`: Output<Int>) {
        this.maxEjectionPercent = value
    }

    /**
     * @param value Number of consecutive errors before the circuit breaker opens
     */
    @JvmName("ghniqgryontgfbeb")
    public suspend fun consecutiveErrors(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consecutiveErrors = mapped
    }

    /**
     * @param value The time interval, in seconds, between endpoint checks. This can result in opening the circuit breaker if the check fails as well as closing the circuit breaker if the check succeeds. Defaults to 10s.
     */
    @JvmName("bvcfaotsnrjryoxs")
    public suspend fun intervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    /**
     * @param value Maximum percentage of hosts that will be ejected after failure threshold has been met
     */
    @JvmName("haqucwurdjhblkyg")
    public suspend fun maxEjectionPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEjectionPercent = mapped
    }

    internal fun build(): CircuitBreakerPolicyArgs = CircuitBreakerPolicyArgs(
        consecutiveErrors = consecutiveErrors,
        intervalInSeconds = intervalInSeconds,
        maxEjectionPercent = maxEjectionPercent,
    )
}
