@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerAppProbeArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
 * @property failureThreshold Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
 * @property httpGet HTTPGet specifies the http request to perform.
 * @property initialDelaySeconds Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
 * @property periodSeconds How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
 * @property successThreshold Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
 * @property tcpSocket TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
 * @property terminationGracePeriodSeconds Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
 * @property timeoutSeconds Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
 * @property type The type of probe.
 */
public data class ContainerAppProbeArgs(
    public val failureThreshold: Output<Int>? = null,
    public val httpGet: Output<ContainerAppProbeHttpGetArgs>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val successThreshold: Output<Int>? = null,
    public val tcpSocket: Output<ContainerAppProbeTcpSocketArgs>? = null,
    public val terminationGracePeriodSeconds: Output<Double>? = null,
    public val timeoutSeconds: Output<Int>? = null,
    public val type: Output<Either<String, Type>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerAppProbeArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerAppProbeArgs =
        com.pulumi.azurenative.app.inputs.ContainerAppProbeArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .httpGet(httpGet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .tcpSocket(tcpSocket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .terminationGracePeriodSeconds(terminationGracePeriodSeconds?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerAppProbeArgs].
 */
@PulumiTagMarker
public class ContainerAppProbeArgsBuilder internal constructor() {
    private var failureThreshold: Output<Int>? = null

    private var httpGet: Output<ContainerAppProbeHttpGetArgs>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var successThreshold: Output<Int>? = null

    private var tcpSocket: Output<ContainerAppProbeTcpSocketArgs>? = null

    private var terminationGracePeriodSeconds: Output<Double>? = null

    private var timeoutSeconds: Output<Int>? = null

    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
     */
    @JvmName("nkdafmiqaobpiyld")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value HTTPGet specifies the http request to perform.
     */
    @JvmName("ydjujfsyreapejth")
    public suspend fun httpGet(`value`: Output<ContainerAppProbeHttpGetArgs>) {
        this.httpGet = value
    }

    /**
     * @param value Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
     */
    @JvmName("rggdwxedawhvmtga")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
     */
    @JvmName("drmgerrskpbwnqda")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
     */
    @JvmName("plbkekoywphdoqvo")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
     */
    @JvmName("rgeyybagcfgbnuix")
    public suspend fun tcpSocket(`value`: Output<ContainerAppProbeTcpSocketArgs>) {
        this.tcpSocket = value
    }

    /**
     * @param value Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
     */
    @JvmName("ufwbphytkxanilxv")
    public suspend fun terminationGracePeriodSeconds(`value`: Output<Double>) {
        this.terminationGracePeriodSeconds = value
    }

    /**
     * @param value Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
     */
    @JvmName("cxbaotyffmoptbgl")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value The type of probe.
     */
    @JvmName("rargvngoncymtgox")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
     */
    @JvmName("diubhabascsvctld")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value HTTPGet specifies the http request to perform.
     */
    @JvmName("erelualgyalskrrf")
    public suspend fun httpGet(`value`: ContainerAppProbeHttpGetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGet = mapped
    }

    /**
     * @param argument HTTPGet specifies the http request to perform.
     */
    @JvmName("suubtvvlorxixave")
    public suspend fun httpGet(argument: suspend ContainerAppProbeHttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerAppProbeHttpGetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpGet = mapped
    }

    /**
     * @param value Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
     */
    @JvmName("ufncvdqwyxkwrslj")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
     */
    @JvmName("runvacadfpwjavrh")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
     */
    @JvmName("samsypblfeokmkeq")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
     */
    @JvmName("ekyfsxxtfyxcmodl")
    public suspend fun tcpSocket(`value`: ContainerAppProbeTcpSocketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpSocket = mapped
    }

    /**
     * @param argument TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
     */
    @JvmName("volgwwqrddehfvyb")
    public suspend fun tcpSocket(argument: suspend ContainerAppProbeTcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerAppProbeTcpSocketArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcpSocket = mapped
    }

    /**
     * @param value Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
     */
    @JvmName("gqihxdxtcobjjxgs")
    public suspend fun terminationGracePeriodSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationGracePeriodSeconds = mapped
    }

    /**
     * @param value Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
     */
    @JvmName("wvoqqerupslbyegi")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    /**
     * @param value The type of probe.
     */
    @JvmName("nuxydodaxgpveats")
    public suspend fun type(`value`: Either<String, Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of probe.
     */
    @JvmName("xxdbvungekflsdod")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of probe.
     */
    @JvmName("asvdafbtauolegkx")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContainerAppProbeArgs = ContainerAppProbeArgs(
        failureThreshold = failureThreshold,
        httpGet = httpGet,
        initialDelaySeconds = initialDelaySeconds,
        periodSeconds = periodSeconds,
        successThreshold = successThreshold,
        tcpSocket = tcpSocket,
        terminationGracePeriodSeconds = terminationGracePeriodSeconds,
        timeoutSeconds = timeoutSeconds,
        type = type,
    )
}
