@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App container definition
 * @property args Container start command arguments.
 * @property command Container start command.
 * @property env Container environment variables.
 * @property image Container image tag.
 * @property name Custom container name.
 * @property probes List of probes for the container.
 * @property resources Container resource requirements.
 * @property volumeMounts Container volume mounts.
 */
public data class ContainerArgs(
    public val args: Output<List<String>>? = null,
    public val command: Output<List<String>>? = null,
    public val env: Output<List<EnvironmentVarArgs>>? = null,
    public val image: Output<String>? = null,
    public val name: Output<String>? = null,
    public val probes: Output<List<ContainerAppProbeArgs>>? = null,
    public val resources: Output<ContainerResourcesArgs>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerArgs =
        com.pulumi.azurenative.app.inputs.ContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .env(env?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .image(image?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .probes(probes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerArgs].
 */
@PulumiTagMarker
public class ContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var command: Output<List<String>>? = null

    private var env: Output<List<EnvironmentVarArgs>>? = null

    private var image: Output<String>? = null

    private var name: Output<String>? = null

    private var probes: Output<List<ContainerAppProbeArgs>>? = null

    private var resources: Output<ContainerResourcesArgs>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value Container start command arguments.
     */
    @JvmName("egkwdmnkeymrwgka")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("ulmaugvghsmxnfyg")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("cicynqbmsargxwnk")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Container start command.
     */
    @JvmName("luxeescbolcjgpxy")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("qwmdilonsvtyfbqj")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values Container start command.
     */
    @JvmName("yjuhndufttfejorl")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("fmlerosvmichhhha")
    public suspend fun env(`value`: Output<List<EnvironmentVarArgs>>) {
        this.env = value
    }

    @JvmName("nffpwbbcbgcnpnka")
    public suspend fun env(vararg values: Output<EnvironmentVarArgs>) {
        this.env = Output.all(values.asList())
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("oukndhnccsnjebuh")
    public suspend fun env(values: List<Output<EnvironmentVarArgs>>) {
        this.env = Output.all(values)
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("jrtfggupsuexnkjb")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("fxnclsxsibbayklg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of probes for the container.
     */
    @JvmName("ndddjfxccgahavxb")
    public suspend fun probes(`value`: Output<List<ContainerAppProbeArgs>>) {
        this.probes = value
    }

    @JvmName("qthebsnvdpgspqak")
    public suspend fun probes(vararg values: Output<ContainerAppProbeArgs>) {
        this.probes = Output.all(values.asList())
    }

    /**
     * @param values List of probes for the container.
     */
    @JvmName("oiahpcjsuxdfhldo")
    public suspend fun probes(values: List<Output<ContainerAppProbeArgs>>) {
        this.probes = Output.all(values)
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("wybalparlurrqfdl")
    public suspend fun resources(`value`: Output<ContainerResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Container volume mounts.
     */
    @JvmName("ygyalxodpoourqub")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("gdmqirbtwudghuwr")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values Container volume mounts.
     */
    @JvmName("ruiarpqygecppwqm")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value Container start command arguments.
     */
    @JvmName("gyvkxviicdvgjgnp")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("ijavmaujjddnxslq")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Container start command.
     */
    @JvmName("mkrmhsxsrnwmjqne")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values Container start command.
     */
    @JvmName("rcqlevojionbdvgl")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("slgsamkbtyqpxjnd")
    public suspend fun env(`value`: List<EnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("brwjccaiovsnltan")
    public suspend fun env(argument: List<suspend EnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("wagggwqgbrqdubml")
    public suspend fun env(vararg argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("qfgyimnldmassjon")
    public suspend fun env(argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVarArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("ujygschblrsqyewe")
    public suspend fun env(vararg values: EnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("qkuttsekjqwbruxx")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("ksuafosldjrfjxbo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of probes for the container.
     */
    @JvmName("roipujuxejrosoyq")
    public suspend fun probes(`value`: List<ContainerAppProbeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param argument List of probes for the container.
     */
    @JvmName("rrqbuvtvcaqingxo")
    public suspend fun probes(argument: List<suspend ContainerAppProbeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerAppProbeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument List of probes for the container.
     */
    @JvmName("erpuhkttyfbsnjij")
    public suspend fun probes(vararg argument: suspend ContainerAppProbeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerAppProbeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument List of probes for the container.
     */
    @JvmName("nyyintxraxwwbxuo")
    public suspend fun probes(argument: suspend ContainerAppProbeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerAppProbeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param values List of probes for the container.
     */
    @JvmName("gmrwigyseutbirir")
    public suspend fun probes(vararg values: ContainerAppProbeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("euvoanabvlexxhrc")
    public suspend fun resources(`value`: ContainerResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Container resource requirements.
     */
    @JvmName("qswrfghqqoqdbchq")
    public suspend fun resources(argument: suspend ContainerResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value Container volume mounts.
     */
    @JvmName("ukfwgnauoymwqtqy")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("gphautmsipxtgkno")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("conggyaahwfdcqlu")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("ldjqqnbieqouxlqi")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values Container volume mounts.
     */
    @JvmName("gxmdmyfehxbcrusr")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): ContainerArgs = ContainerArgs(
        args = args,
        command = command,
        env = env,
        image = image,
        name = name,
        probes = probes,
        resources = resources,
        volumeMounts = volumeMounts,
    )
}
