@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerRegistryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model representing a mapping from a container registry to the identity used to connect to it.
 * @property containerRegistryServer Login server of the container registry.
 * @property identityResourceId Resource ID of the managed identity.
 */
public data class ContainerRegistryArgs(
    public val containerRegistryServer: Output<String>,
    public val identityResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerRegistryArgs =
        com.pulumi.azurenative.app.inputs.ContainerRegistryArgs.builder()
            .containerRegistryServer(containerRegistryServer.applyValue({ args0 -> args0 }))
            .identityResourceId(identityResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRegistryArgs].
 */
@PulumiTagMarker
public class ContainerRegistryArgsBuilder internal constructor() {
    private var containerRegistryServer: Output<String>? = null

    private var identityResourceId: Output<String>? = null

    /**
     * @param value Login server of the container registry.
     */
    @JvmName("jdxiscytlwtodjjy")
    public suspend fun containerRegistryServer(`value`: Output<String>) {
        this.containerRegistryServer = value
    }

    /**
     * @param value Resource ID of the managed identity.
     */
    @JvmName("aixfukdquosdewue")
    public suspend fun identityResourceId(`value`: Output<String>) {
        this.identityResourceId = value
    }

    /**
     * @param value Login server of the container registry.
     */
    @JvmName("qpruijvacsmbxiyt")
    public suspend fun containerRegistryServer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerRegistryServer = mapped
    }

    /**
     * @param value Resource ID of the managed identity.
     */
    @JvmName("fahyhtcmermelrim")
    public suspend fun identityResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityResourceId = mapped
    }

    internal fun build(): ContainerRegistryArgs = ContainerRegistryArgs(
        containerRegistryServer = containerRegistryServer ?: throw
            PulumiNullFieldException("containerRegistryServer"),
        identityResourceId = identityResourceId ?: throw PulumiNullFieldException("identityResourceId"),
    )
}
